/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.logging.log4j;

import com.atlassian.logging.log4j.LogMessageUtil;
import java.util.ArrayList;

public class StackTraceInfo {
    private final Throwable throwable;
    private final String lineIndent;
    ArrayList<String> lines = new ArrayList();

    public StackTraceInfo(Throwable throwable, String lineIndent) {
        this.throwable = throwable;
        this.lineIndent = lineIndent;
    }

    public String[] getStringRep() {
        String message = this.throwable.toString();
        this.lines.add(LogMessageUtil.appendLineIndent(message, this.lineIndent));
        this.addStackTraceLines(this.throwable.getStackTrace(), this.throwable.getStackTrace().length - 1);
        if (this.throwable.getCause() != null) {
            this.addCausedByThrowableInformation(this.throwable.getCause(), this.throwable.getStackTrace());
        }
        return this.lines.toArray(new String[this.lines.size()]);
    }

    private void addCausedByThrowableInformation(Throwable cause, StackTraceElement[] parentStackTrace) {
        String message = cause.toString();
        StackTraceElement[] stacktrace = cause.getStackTrace();
        int endUniqueFrames = this.getCauseStackTraceElementStart(parentStackTrace, stacktrace);
        this.lines.add("Caused by: " + LogMessageUtil.appendLineIndent(message, this.lineIndent));
        this.addStackTraceLines(stacktrace, endUniqueFrames);
        int more = stacktrace.length - 1 - endUniqueFrames;
        if (more > 0) {
            this.lines.add("\t... " + more + " more");
        }
        if (cause.getCause() != null) {
            this.addCausedByThrowableInformation(cause.getCause(), stacktrace);
        }
    }

    private void addStackTraceLines(StackTraceElement[] stackTraceElements, int endPos) {
        for (int i = 0; i <= endPos; ++i) {
            this.lines.add("\tat " + stackTraceElements[i]);
        }
    }

    private int getCauseStackTraceElementStart(StackTraceElement[] parentElements, StackTraceElement[] causeElements) {
        int causeStart;
        int i = parentElements.length - 1;
        for (causeStart = causeElements.length - 1; causeStart >= 0 && i >= 0 && causeElements[causeStart].equals(parentElements[i]); --causeStart, --i) {
        }
        return causeStart;
    }
}

