/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.logging.log4j;

import com.atlassian.logging.log4j.FilteredPatternLayout;
import com.atlassian.logging.log4j.NewLineLogMessagePatternParser;
import com.atlassian.logging.log4j.StackTraceInfo;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.ThrowableInformation;

public class NewLineIndentingFilteringPatternLayout
extends FilteredPatternLayout {
    public static final String DEFAULT_NEW_LINE_PREFIX = "    ";
    private String lineIndent;

    public NewLineIndentingFilteringPatternLayout() {
        this(DEFAULT_NEW_LINE_PREFIX);
    }

    public NewLineIndentingFilteringPatternLayout(String lineIndent) {
        this.setFilteringApplied(false);
        this.setLineIndent(lineIndent);
    }

    protected PatternParser createPatternParser(String pattern) {
        return new NewLineLogMessagePatternParser(pattern, this.lineIndent);
    }

    @Override
    protected String[] getThrowableStrRep(ThrowableInformation throwableInformation) {
        return new StackTraceInfo(throwableInformation.getThrowable(), this.lineIndent).getStringRep();
    }

    public String getLineIndent() {
        return this.lineIndent;
    }

    public void setLineIndent(String lineIndent) {
        this.lineIndent = lineIndent;
        this.setConversionPattern(this.getConversionPattern());
    }
}

