/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.logging.log4j;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class FilteredPatternLayout
extends PatternLayout {
    private static String NL;
    private boolean filteringApplied = true;
    private boolean filteringAppliedToDebugLevel = false;
    private final Set<String> filteredFrames = new HashSet<String>();
    private final Set<String> filterEveryThingAfterFrames = new HashSet<String>();
    private final Set<String> markerAtFrames = new HashSet<String>();
    private String filterEveryThingAfterMessage = "\t\t(The rest of the stack trace has been filtered ...)";
    private String filterReplacementToken = "... ";
    private String markerAtMessage = NL;
    private int minimumLines = 6;
    private boolean showEludedSummary = false;
    private static Pattern CALL_SITE;

    public void setFilteredFrames(String filterSpec) {
        this.parseFilterSpec(filterSpec, this.filteredFrames);
    }

    public void setFilterEveryThingAfterFrames(String filterSpec) {
        this.parseFilterSpec(filterSpec, this.filterEveryThingAfterFrames);
    }

    public void setMarkerAtFrames(String filterSpec) {
        this.parseFilterSpec(filterSpec, this.markerAtFrames);
    }

    public boolean isFilteringAppliedToDebugLevel() {
        return this.filteringAppliedToDebugLevel;
    }

    public void setFilteringAppliedToDebugLevel(boolean filteringAppliedToDebugLevel) {
        this.filteringAppliedToDebugLevel = filteringAppliedToDebugLevel;
    }

    public String getFilterReplacementToken() {
        return this.filterReplacementToken;
    }

    public void setFilterReplacementToken(String filterReplacementToken) {
        this.filterReplacementToken = StringUtils.defaultString((String)filterReplacementToken);
    }

    public String getFilterEveryThingAfterMessage() {
        return this.filterEveryThingAfterMessage;
    }

    public void setFilterEveryThingAfterMessage(String filterEveryThingAfterMessage) {
        this.filterEveryThingAfterMessage = StringUtils.defaultString((String)filterEveryThingAfterMessage);
    }

    public String getMarkerAtMessage() {
        return this.filterEveryThingAfterMessage;
    }

    public void setMarkerAtMessage(String markerAtMessage) {
        this.markerAtMessage = StringUtils.defaultString((String)markerAtMessage);
    }

    public boolean isFilteringApplied() {
        return this.filteringApplied;
    }

    public void setFilteringApplied(boolean filteringApplied) {
        this.filteringApplied = filteringApplied;
    }

    public int getMinimumLines() {
        return this.minimumLines;
    }

    public void setMinimumLines(int minimumLines) {
        this.minimumLines = minimumLines;
    }

    public boolean isShowEludedSummary() {
        return this.showEludedSummary;
    }

    public void setShowEludedSummary(boolean showEludedSummary) {
        this.showEludedSummary = showEludedSummary;
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public String format(LoggingEvent event) {
        ThrowableInformation throwableInformation = event.getThrowableInformation();
        String superFormatted = super.format(event);
        if (throwableInformation == null) {
            return superFormatted;
        }
        return this.formatStackTrace(event, throwableInformation, superFormatted);
    }

    private String formatStackTrace(LoggingEvent event, ThrowableInformation throwableInformation, String formattedByPattern) {
        StringBuffer buffer = new StringBuffer(formattedByPattern);
        String[] stackTraceLines = this.getThrowableStrRep(throwableInformation);
        if (!this.filteringApplied || Level.DEBUG.equals((Object)event.getLevel()) && !this.filteringAppliedToDebugLevel) {
            this.outputPlainThrowable(buffer, stackTraceLines);
        } else {
            this.outputFilteredThrowable(buffer, stackTraceLines);
        }
        return buffer.toString();
    }

    protected String[] getThrowableStrRep(ThrowableInformation throwableInformation) {
        return throwableInformation.getThrowableStrRep();
    }

    private void outputPlainThrowable(StringBuffer buffer, String[] stackTraceLines) {
        for (String stackTraceLine : stackTraceLines) {
            buffer.append(stackTraceLine).append(NL);
        }
    }

    private void outputFilteredThrowable(StringBuffer buffer, String[] stackTraceLines) {
        int lineCount = 0;
        int filteredCount = 0;
        boolean ignoreLinesUntilEnd = false;
        boolean markerDue = false;
        ArrayList<String> eludedLineSummary = new ArrayList<String>(stackTraceLines.length);
        for (lineCount = this.outputMinimumLines(buffer, stackTraceLines, lineCount, this.minimumLines); lineCount < stackTraceLines.length; ++lineCount) {
            String summary;
            String stackTraceLine = stackTraceLines[lineCount];
            boolean filteredLine = false;
            if (this.causedBy(stackTraceLine)) {
                this.appendSkipIndicators(buffer, filteredCount, eludedLineSummary);
                lineCount = this.outputMinimumLines(buffer, stackTraceLines, lineCount, this.minimumLines);
                ignoreLinesUntilEnd = false;
                continue;
            }
            if (this.lineMatchesPattern(stackTraceLine, this.filterEveryThingAfterFrames)) {
                this.appendSkipIndicators(buffer, filteredCount, eludedLineSummary);
                buffer.append(this.filterEveryThingAfterMessage);
                filteredCount = 0;
                ignoreLinesUntilEnd = true;
            } else if (this.lineMatchesPattern(stackTraceLine, this.filteredFrames)) {
                ++filteredCount;
                filteredLine = true;
            }
            if (ignoreLinesUntilEnd) {
                filteredLine = true;
            }
            if (!filteredLine) {
                this.appendSkipIndicators(buffer, filteredCount, eludedLineSummary);
                if (markerDue) {
                    buffer.append(this.markerAtMessage).append(NL);
                    markerDue = false;
                }
                buffer.append(stackTraceLine);
                if (this.lineMatchesPattern(stackTraceLine, this.markerAtFrames)) {
                    markerDue = true;
                }
                filteredCount = 0;
                continue;
            }
            if (!this.showEludedSummary || !StringUtils.isNotBlank((String)(summary = this.makeEludedSummary(stackTraceLine)))) continue;
            eludedLineSummary.add(summary);
        }
        this.appendSkipIndicators(buffer, filteredCount, eludedLineSummary);
    }

    private int outputMinimumLines(StringBuffer buffer, String[] stackTraceLines, int lineCount, int minimumLines) {
        int minLines = Math.min(lineCount + minimumLines, stackTraceLines.length);
        while (lineCount < minLines) {
            String stackTraceLine = stackTraceLines[lineCount];
            buffer.append(stackTraceLine);
            if (lineCount < minLines - 1) {
                buffer.append(NL);
            }
            ++lineCount;
        }
        return lineCount;
    }

    protected boolean causedBy(String stackTraceLine) {
        return stackTraceLine.startsWith("Caused by:");
    }

    private void appendSkipIndicators(StringBuffer buffer, int filteredCount, List<String> eludedLineSummary) {
        if (filteredCount > 0) {
            buffer.append("  <+").append(filteredCount).append(">");
        }
        if (this.showEludedSummary) {
            for (String summary : eludedLineSummary) {
                buffer.append(" ").append(summary);
            }
            eludedLineSummary.clear();
        }
        int lastChar = buffer.length() - 1;
        if (buffer.lastIndexOf(NL) != lastChar) {
            buffer.append(NL);
        }
    }

    private boolean lineMatchesPattern(String string, Set<String> filterSet) {
        if (!filterSet.isEmpty()) {
            Iterator<String> iterator = filterSet.iterator();
            while (iterator.hasNext()) {
                if (!string.trim().startsWith(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    private void parseFilterSpec(String filterSpec, Set<String> filterSet) {
        if (StringUtils.isNotBlank((String)filterSpec)) {
            String[] split;
            for (String filter : split = filterSpec.split(",")) {
                String trimmed = StringUtils.trim((String)filter);
                if (!StringUtils.isNotBlank((String)trimmed)) continue;
                filterSet.add("at " + trimmed);
            }
        }
    }

    private String makeEludedSummary(String stackTraceLine) {
        Matcher matcher = CALL_SITE.matcher(stackTraceLine);
        if (matcher.find() && matcher.groupCount() >= 1) {
            return matcher.group(1);
        }
        return null;
    }

    static {
        try {
            NL = System.getProperty("line.separator");
        }
        catch (SecurityException ignore) {
            NL = "\n";
        }
        CALL_SITE = Pattern.compile("(\\(.*:[0-9]+\\))");
    }
}

