package com.atlassian.logging.log4j;

import java.util.ArrayList;

public class StackTraceInfo
{
    private final Throwable throwable;
    private final String lineIndent;
    ArrayList<String> lines = new ArrayList<String>();

    public StackTraceInfo(final Throwable throwable, final String lineIndent)
    {
        this.throwable = throwable;
        this.lineIndent = lineIndent;
    }

    public String[] getStringRep()
    {
        final String message = throwable.toString();

        lines.add(LogMessageUtil.appendLineIndent(message, lineIndent));
        addStackTraceLines(throwable.getStackTrace(), throwable.getStackTrace().length - 1);

        if (throwable.getCause() != null)
        {
            addCausedByThrowableInformation(throwable.getCause(), throwable.getStackTrace());
        }
        return lines.toArray(new String[lines.size()]);
    }

    private void addCausedByThrowableInformation(final Throwable cause, final StackTraceElement[] parentStackTrace)
    {
        final String message = cause.toString();

        StackTraceElement[] stacktrace = cause.getStackTrace();

        final int endUniqueFrames = getCauseStackTraceElementStart(parentStackTrace, stacktrace);

        lines.add("Caused by: " + LogMessageUtil.appendLineIndent(message, lineIndent));
        addStackTraceLines(stacktrace, endUniqueFrames);

        int more = stacktrace.length - 1 - endUniqueFrames;
        if (more > 0)
        {
            lines.add("\t... " + more + " more");
        }

        if (cause.getCause() != null)
        {
            addCausedByThrowableInformation(cause.getCause(), stacktrace);
        }
    }

    private void addStackTraceLines(final StackTraceElement[] stackTraceElements, final int endPos)
    {
        for (int i = 0; i <= endPos; i++)
        {
            lines.add("\tat " + stackTraceElements[i]);
        }
    }

    private int getCauseStackTraceElementStart(final StackTraceElement[] parentElements, final StackTraceElement[] causeElements)
    {
        int i = parentElements.length - 1;
        int causeStart = causeElements.length - 1;
        while (causeStart >= 0 && i >=0 && causeElements[causeStart].equals(parentElements[i]))
        {
            --causeStart;
            --i;
        }
        return causeStart;
    }
}