/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.validator;

import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.api.exception.CannotRetrieveKeyException;
import com.atlassian.asap.api.exception.InvalidTokenException;
import com.atlassian.asap.core.keys.KeyProvider;
import com.atlassian.asap.core.parser.JwtParser;
import com.atlassian.asap.core.parser.VerifiableJwt;
import com.atlassian.asap.core.server.AuthenticationContext;
import com.atlassian.asap.core.validator.JwtClaimsValidator;
import com.atlassian.asap.core.validator.JwtRevalidator;
import com.atlassian.asap.core.validator.JwtValidator;
import com.atlassian.asap.core.validator.ValidatedKeyId;
import com.atlassian.asap.nimbus.parser.NimbusJwtParser;
import java.security.PublicKey;
import java.time.Clock;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public class JwtValidatorImpl
implements JwtValidator,
JwtRevalidator {
    private final KeyProvider<PublicKey> publicKeyProvider;
    private final JwtParser jwtParser;
    private final JwtClaimsValidator jwtClaimsValidator;
    private final Supplier<Set<String>> resourceServerAudiences;

    public JwtValidatorImpl(KeyProvider<PublicKey> publicKeyProvider, JwtParser jwtParser, JwtClaimsValidator claimValidator, Supplier<Set<String>> resourceServerAudiences) {
        this.publicKeyProvider = Objects.requireNonNull(publicKeyProvider);
        this.jwtParser = Objects.requireNonNull(jwtParser);
        this.jwtClaimsValidator = Objects.requireNonNull(claimValidator);
        this.resourceServerAudiences = Objects.requireNonNull(resourceServerAudiences);
    }

    public JwtValidatorImpl(KeyProvider<PublicKey> publicKeyProvider, JwtParser jwtParser, JwtClaimsValidator claimValidator, Set<String> resourceServerAudiences) {
        this(publicKeyProvider, jwtParser, claimValidator, () -> resourceServerAudiences);
    }

    public JwtValidatorImpl(KeyProvider<PublicKey> publicKeyProvider, JwtParser jwtParser, JwtClaimsValidator claimValidator, String resourceServerAudience) {
        this(publicKeyProvider, jwtParser, claimValidator, Collections.singleton(resourceServerAudience));
    }

    @Override
    public final Jwt readAndValidate(String serializedJwt) throws InvalidTokenException, CannotRetrieveKeyException {
        VerifiableJwt verifiableJwt = this.jwtParser.parse(serializedJwt);
        ValidatedKeyId validatedKeyId = ValidatedKeyId.validate((String)verifiableJwt.getHeader().getKeyId());
        PublicKey publicKey = (PublicKey)this.publicKeyProvider.getKey(validatedKeyId);
        verifiableJwt.verifySignature(publicKey);
        this.jwtClaimsValidator.validate((Jwt)verifiableJwt, this.resourceServerAudiences.get());
        return verifiableJwt;
    }

    @Override
    public final Optional<String> determineUnverifiedIssuer(String serializedJwt) {
        return this.jwtParser.determineUnverifiedIssuer(serializedJwt);
    }

    @Override
    public void revalidateClaims(Jwt jwt) throws InvalidTokenException {
        this.jwtClaimsValidator.validate(jwt, this.resourceServerAudiences.get());
    }

    public static JwtValidator createDefault(AuthenticationContext authenticationContext) {
        return new JwtValidatorImpl(authenticationContext.getPublicKeyProvider(), (JwtParser)new NimbusJwtParser(), new JwtClaimsValidator(Clock.systemUTC()), authenticationContext.getResourceServerAudiences());
    }

    public static JwtValidator createDefault(String audience, String publicKeyRepoBaseUrl) {
        AuthenticationContext authContext = new AuthenticationContext(audience, publicKeyRepoBaseUrl);
        return JwtValidatorImpl.createDefault(authContext);
    }

    public static JwtValidator createDefault(Set<String> audiences, String publicKeyRepoBaseUrl) {
        AuthenticationContext authContext = new AuthenticationContext(audiences, publicKeyRepoBaseUrl);
        return JwtValidatorImpl.createDefault(authContext);
    }
}

