/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.validator;

import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.api.exception.CannotRetrieveKeyException;
import com.atlassian.asap.api.exception.InvalidTokenException;
import com.atlassian.asap.core.validator.JwtRevalidator;
import com.atlassian.asap.core.validator.JwtValidator;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class CachingJwtValidator
implements JwtValidator {
    private final JwtValidator delegate;
    private final JwtRevalidator revalidator;
    private final Cache<String, Jwt> tokenCache;
    private final int maxEntryLength;

    public CachingJwtValidator(JwtValidator delegate, JwtRevalidator revalidator, int maxCacheSize, int cacheExpirySec, int maxEntryLength) {
        this.delegate = delegate;
        this.revalidator = revalidator;
        this.maxEntryLength = maxEntryLength;
        this.tokenCache = CacheBuilder.newBuilder().maximumSize((long)maxCacheSize).expireAfterWrite((long)cacheExpirySec, TimeUnit.SECONDS).build();
    }

    @Override
    public Jwt readAndValidate(String serializedJwt) throws InvalidTokenException, CannotRetrieveKeyException {
        if (serializedJwt.length() >= this.maxEntryLength) {
            return this.delegate.readAndValidate(serializedJwt);
        }
        Optional<Object> maybeJwt = Optional.ofNullable(this.tokenCache.getIfPresent((Object)serializedJwt));
        if (maybeJwt.isPresent()) {
            Jwt jwt = (Jwt)maybeJwt.get();
            this.revalidator.revalidateClaims(jwt);
            return jwt;
        }
        Jwt jwt = this.delegate.readAndValidate(serializedJwt);
        this.tokenCache.put((Object)serializedJwt, (Object)jwt);
        return jwt;
    }

    @Override
    public Optional<String> determineUnverifiedIssuer(String serializedJwt) {
        return this.delegate.determineUnverifiedIssuer(serializedJwt);
    }
}

