/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.server.http;

import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.api.exception.AuthenticationFailedException;
import com.atlassian.asap.api.exception.CannotRetrieveKeyException;
import com.atlassian.asap.api.exception.InvalidTokenException;
import com.atlassian.asap.api.exception.PermanentAuthenticationFailedException;
import com.atlassian.asap.api.exception.TransientAuthenticationFailedException;
import com.atlassian.asap.api.server.http.RequestAuthenticator;
import com.atlassian.asap.core.exception.PublicKeyNotFoundException;
import com.atlassian.asap.core.validator.JwtValidator;
import com.atlassian.asap.core.validator.ValidatedKeyId;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestAuthenticatorImpl
implements RequestAuthenticator {
    private static final Logger logger = LoggerFactory.getLogger(RequestAuthenticatorImpl.class);
    private final JwtValidator jwtValidator;

    public RequestAuthenticatorImpl(JwtValidator jwtValidator) {
        this.jwtValidator = Objects.requireNonNull(jwtValidator);
    }

    public Jwt authenticateRequest(String authorizationHeader) throws AuthenticationFailedException {
        if (StringUtils.isBlank((CharSequence)authorizationHeader)) {
            throw new PermanentAuthenticationFailedException("Authorization header is missing");
        }
        if (!authorizationHeader.startsWith("Bearer ")) {
            throw new PermanentAuthenticationFailedException("Authorization header is not in the expected format. Expected format is 'Bearer <jwt token>'");
        }
        String serializedJwt = StringUtils.removeStart((String)authorizationHeader, (String)"Bearer ");
        try {
            return this.jwtValidator.readAndValidate(serializedJwt);
        }
        catch (PublicKeyNotFoundException e) {
            logger.debug("Public key not found when authenticating request: {}", (Object)e.getKeyId(), (Object)e);
            Optional<String> issuer = this.getUnverifiedIssuer(serializedJwt);
            throw new PermanentAuthenticationFailedException(String.format("Public key not found when authenticating request from %s: %s", RequestAuthenticatorImpl.formatIssuer(issuer), e.getMessage()), (String)issuer.orElse(null));
        }
        catch (CannotRetrieveKeyException e) {
            logger.error("Error retrieving key required to authenticate request", (Throwable)e);
            Optional<String> issuer = this.getUnverifiedIssuer(serializedJwt);
            throw new TransientAuthenticationFailedException(String.format("Failed to retrieve the key required to authenticate request from %s: %s", RequestAuthenticatorImpl.formatIssuer(issuer), e.getMessage()), (ValidatedKeyId)e.getKeyId().orElse(null), (URI)e.getKeyUri().orElse(null), (String)issuer.orElse(null));
        }
        catch (InvalidTokenException e) {
            logger.debug("Failed to authenticate request", (Throwable)e);
            Optional<String> issuer = this.getUnverifiedIssuer(serializedJwt);
            throw new PermanentAuthenticationFailedException(String.format("Failed to authenticate request from %s: %s", RequestAuthenticatorImpl.formatIssuer(issuer), e.getSafeDetails()), (String)issuer.orElse(null));
        }
    }

    private Optional<String> getUnverifiedIssuer(String serializedJwt) {
        return this.jwtValidator.determineUnverifiedIssuer(serializedJwt);
    }

    private static String formatIssuer(Optional<String> issuer) {
        return issuer.map(iss -> iss + " (issuer not verified)").orElse("unknown issuer");
    }
}

