/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.server.filter;

import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.core.server.filter.AbstractRequestAuthorizationFilter;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class WhitelistRequestAuthorizationFilter
extends AbstractRequestAuthorizationFilter {
    private final Set<String> authorizedSubjects;
    private final Set<String> authorizedIssuers;

    public WhitelistRequestAuthorizationFilter(Set<String> authorizedSubjects, Set<String> authorizedIssuers) {
        this.authorizedSubjects = ImmutableSet.copyOf(authorizedSubjects);
        this.authorizedIssuers = ImmutableSet.copyOf(authorizedIssuers);
    }

    @Deprecated
    public WhitelistRequestAuthorizationFilter(Set<String> authorizedSubjects) {
        this(authorizedSubjects, authorizedSubjects);
    }

    @Override
    protected boolean isAuthorized(HttpServletRequest request, Jwt jwt) {
        boolean issuerIsAuthorized = this.authorizedIssuers.contains(jwt.getClaims().getIssuer());
        String effectiveSubject = jwt.getClaims().getSubject().orElse(jwt.getClaims().getIssuer());
        boolean subjectIsAuthorized = this.authorizedSubjects.contains(effectiveSubject);
        return issuerIsAuthorized && subjectIsAuthorized;
    }
}

