/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.server.filter;

import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.core.server.filter.AbstractRequestAuthorizationFilter;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;

public class RulesAwareRequestAuthorizationFilter
extends AbstractRequestAuthorizationFilter {
    private final Map<String, Predicate<Jwt>> issuersAndChecks;

    public RulesAwareRequestAuthorizationFilter(Map<String, Predicate<Jwt>> issuersAndChecks) {
        this.issuersAndChecks = ImmutableMap.copyOf(issuersAndChecks);
    }

    @Override
    protected boolean isAuthorized(HttpServletRequest request, Jwt jwt) {
        String issuer = jwt.getClaims().getIssuer();
        return Optional.ofNullable(this.issuersAndChecks.get(issuer)).map(pred -> pred.test(jwt)).orElse(false);
    }
}

