/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.server.filter;

import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.core.server.filter.RulesAwareRequestAuthorizationFilter;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class IssuerAndSubjectAwareRequestAuthorizationFilter
extends RulesAwareRequestAuthorizationFilter {
    public IssuerAndSubjectAwareRequestAuthorizationFilter(Map<String, Predicate<String>> issuersAndSubjectChecks) {
        super(IssuerAndSubjectAwareRequestAuthorizationFilter.toJwtRules(issuersAndSubjectChecks));
    }

    public static IssuerAndSubjectAwareRequestAuthorizationFilter issuers(Set<String> issuers) {
        return new IssuerAndSubjectAwareRequestAuthorizationFilter(IssuerAndSubjectAwareRequestAuthorizationFilter.issuerAndSubjectMatches(issuers));
    }

    private static Map<String, Predicate<String>> issuerAndSubjectMatches(Set<String> issuers) {
        return issuers.stream().collect(Collectors.toMap(Function.identity(), issuer -> issuer::equals));
    }

    private static Map<String, Predicate<Jwt>> toJwtRules(Map<String, Predicate<String>> subjectRules) {
        return subjectRules.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> jwt -> ((Predicate)entry.getValue()).test(jwt.getClaims().getSubject().orElse(jwt.getClaims().getIssuer()))));
    }
}

