/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.server.filter;

import com.atlassian.asap.api.Jwt;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractRequestAuthorizationFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Jwt jwt = (Jwt)httpRequest.getAttribute("asap.authentic.jwt");
        if (jwt == null) {
            this.onTokenNotFound(httpRequest, httpResponse, filterChain);
        } else if (this.isAuthorized(httpRequest, jwt)) {
            this.onAuthorizationSuccess(jwt, httpRequest, httpResponse, filterChain);
        } else {
            this.onAuthorizationFailure(jwt, httpRequest, httpResponse, filterChain);
        }
    }

    protected void onTokenNotFound(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        throw new IllegalStateException("Request authorization filter requires an authentic JWT attribute in the request. Have you added the authentication filter to the chain?");
    }

    protected void onAuthorizationFailure(Jwt jwt, HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        response.sendError(403);
    }

    protected void onAuthorizationSuccess(Jwt jwt, HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected abstract boolean isAuthorized(HttpServletRequest var1, Jwt var2);

    public void destroy() {
    }
}

