/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.server.filter;

import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.api.exception.AuthenticationFailedException;
import com.atlassian.asap.api.exception.TransientAuthenticationFailedException;
import com.atlassian.asap.api.server.http.RequestAuthenticator;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequestAuthenticationFilter
implements Filter {
    public static final String AUTHENTIC_JWT_REQUEST_ATTRIBUTE = "asap.authentic.jwt";
    private static final Logger logger = LoggerFactory.getLogger(AbstractRequestAuthenticationFilter.class);
    private RequestAuthenticator requestAuthenticator;
    private boolean allowAnonymousRequests;

    public AbstractRequestAuthenticationFilter() {
        this(false);
    }

    public AbstractRequestAuthenticationFilter(boolean allowAnonymousRequests) {
        this.allowAnonymousRequests = allowAnonymousRequests;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.requestAuthenticator = this.getRequestAuthenticator(filterConfig);
    }

    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Preconditions.checkState((this.requestAuthenticator != null ? 1 : 0) != 0, (Object)"Filter has not been initialized");
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String authorizationHeader = httpRequest.getHeader("Authorization");
        if (StringUtils.isBlank((CharSequence)authorizationHeader)) {
            if (this.allowAnonymousRequests) {
                logger.debug("Allowing request with no JWT token.");
                this.onAuthenticationSuccess(null, httpRequest, httpResponse, chain);
            } else {
                logger.debug("Request rejected because JWT token cannot be found");
                this.onAuthenticationFailure(httpRequest, httpResponse, chain);
            }
        } else {
            try {
                Jwt authenticJwt = this.requestAuthenticator.authenticateRequest(authorizationHeader);
                logger.trace("Accepting authentic token with identifier {}", (Object)authenticJwt.getClaims().getJwtId());
                this.saveToken(request, authenticJwt);
                this.onAuthenticationSuccess(authenticJwt, httpRequest, httpResponse, chain);
            }
            catch (TransientAuthenticationFailedException e) {
                logger.debug("Request rejected because JWT token could not be verified at this time", (Throwable)e);
                this.onAuthenticationError(httpRequest, httpResponse, chain, e);
            }
            catch (AuthenticationFailedException e) {
                logger.debug("Request rejected because JWT token cannot be verified", (Throwable)e);
                this.onAuthenticationFailure(httpRequest, httpResponse, chain);
            }
        }
    }

    protected void saveToken(ServletRequest request, Jwt authenticJwt) {
        request.setAttribute(AUTHENTIC_JWT_REQUEST_ATTRIBUTE, (Object)authenticJwt);
    }

    protected void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        response.sendError(401);
        response.setHeader("WWW-Authenticate", "Bearer");
    }

    protected void onAuthenticationError(HttpServletRequest request, HttpServletResponse response, FilterChain chain, TransientAuthenticationFailedException e) throws IOException, ServletException {
        logger.error("An error occurred while authenticating this request", (Throwable)e);
        response.sendError(503);
    }

    protected void onAuthenticationSuccess(Jwt authenticJwt, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }

    protected abstract RequestAuthenticator getRequestAuthenticator(FilterConfig var1);
}

