/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.server;

import com.atlassian.asap.core.keys.KeyProvider;
import com.atlassian.asap.core.keys.publickey.PublicKeyProviderFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class AuthenticationContext {
    private final Set<String> resourceServerAudiences;
    private final KeyProvider<PublicKey> publicKeyProvider;

    public AuthenticationContext(@Nonnull String resourceServerAudience, @Nonnull String publicKeyServerBaseUrl) {
        this((Set<String>)ImmutableSet.of((Object)Objects.requireNonNull(resourceServerAudience)), publicKeyServerBaseUrl);
    }

    public AuthenticationContext(@Nonnull Set<String> resourceServerAudiences, @Nonnull String publicKeyServerBaseUrl) {
        this(resourceServerAudiences, (KeyProvider<PublicKey>)PublicKeyProviderFactory.createDefault().createPublicKeyProvider(publicKeyServerBaseUrl));
    }

    public AuthenticationContext(@Nonnull String resourceServerAudience, @Nonnull KeyProvider<PublicKey> publicKeyProvider) {
        this((Set<String>)ImmutableSet.of((Object)Objects.requireNonNull(resourceServerAudience)), publicKeyProvider);
    }

    public AuthenticationContext(@Nonnull Set<String> resourceServerAudiences, @Nonnull KeyProvider<PublicKey> publicKeyProvider) {
        this.resourceServerAudiences = ImmutableSet.copyOf((Collection)Objects.requireNonNull(resourceServerAudiences));
        this.publicKeyProvider = Objects.requireNonNull(publicKeyProvider);
    }

    @Deprecated
    public String getResourceServerAudience() {
        Preconditions.checkState((this.resourceServerAudiences.size() == 1 ? 1 : 0) != 0, (Object)"Legacy getResourceServerAudience can only be called if a single audience value has been set.");
        return (String)Iterables.getFirst(this.resourceServerAudiences, null);
    }

    public Set<String> getResourceServerAudiences() {
        return this.resourceServerAudiences;
    }

    public KeyProvider<PublicKey> getPublicKeyProvider() {
        return this.publicKeyProvider;
    }
}

