/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.nimbus.serializer;

import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

class Jsr353NimbusTranslator {
    Jsr353NimbusTranslator() {
    }

    static Object jsr353ToNimbus(JsonValue jsonValue) {
        switch (jsonValue.getValueType()) {
            case NULL: {
                return null;
            }
            case STRING: {
                return ((JsonString)jsonValue).getString();
            }
            case NUMBER: {
                return Jsr353NimbusTranslator.convertNumber((JsonNumber)jsonValue);
            }
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
            case ARRAY: {
                return Jsr353NimbusTranslator.convertArray((JsonArray)jsonValue);
            }
            case OBJECT: {
                return Jsr353NimbusTranslator.convertObject((JsonObject)jsonValue);
            }
        }
        throw new IllegalStateException("Broken JSON");
    }

    private static Object convertNumber(JsonNumber jsonNumber) {
        if (jsonNumber.isIntegral()) {
            return jsonNumber.longValueExact();
        }
        return jsonNumber.doubleValue();
    }

    private static Object convertArray(JsonArray jsonValue) {
        JSONArray nimbusArray = new JSONArray();
        for (JsonValue arrayElement : jsonValue) {
            nimbusArray.add(Jsr353NimbusTranslator.jsr353ToNimbus(arrayElement));
        }
        return nimbusArray;
    }

    private static Object convertObject(JsonObject jsonValue) {
        JSONObject nimbusObject = new JSONObject();
        for (Map.Entry entry : jsonValue.entrySet()) {
            nimbusObject.put(entry.getKey(), Jsr353NimbusTranslator.jsr353ToNimbus((JsonValue)entry.getValue()));
        }
        return nimbusObject;
    }
}

