/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.nimbus.parser;

import com.atlassian.asap.api.JwsHeader;
import com.atlassian.asap.api.JwtClaims;
import com.atlassian.asap.core.SecurityProvider;
import com.atlassian.asap.core.exception.JwtParseException;
import com.atlassian.asap.core.exception.MissingRequiredClaimException;
import com.atlassian.asap.core.exception.MissingRequiredHeaderException;
import com.atlassian.asap.core.exception.UnsupportedAlgorithmException;
import com.atlassian.asap.core.parser.JwtParser;
import com.atlassian.asap.core.parser.VerifiableJwt;
import com.atlassian.asap.nimbus.parser.NimbusVerifiableJwt;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jwt.JWTClaimsSet;
import java.security.Provider;
import java.text.ParseException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.minidev.json.JSONObject;

public class NimbusJwtParser
implements JwtParser {
    private final Provider provider;

    public NimbusJwtParser() {
        this(SecurityProvider.getProvider());
    }

    public NimbusJwtParser(Provider provider) {
        this.provider = provider;
    }

    @Override
    public VerifiableJwt parse(String serializedJwt) throws JwtParseException, UnsupportedAlgorithmException {
        JWTClaimsSet claims;
        JWSObject jwsObject;
        try {
            jwsObject = JWSObject.parse((String)Objects.requireNonNull(serializedJwt));
            this.validateRequiredHeaders(jwsObject);
            JSONObject jsonPayload = Optional.ofNullable(jwsObject.getPayload()).map(Payload::toJSONObject).orElseThrow(() -> new JwtParseException("malformed payload"));
            claims = JWTClaimsSet.parse((JSONObject)jsonPayload);
        }
        catch (ParseException e) {
            throw new JwtParseException(e);
        }
        this.validateRequiredClaims(claims);
        try {
            return NimbusVerifiableJwt.buildVerifiableJwt(jwsObject, claims, this.provider);
        }
        catch (NumberFormatException ex) {
            throw new JwtParseException("unrepresentable JSON values", ex);
        }
    }

    @Override
    public Optional<String> determineUnverifiedIssuer(String serializedJwt) {
        try {
            JWSObject jwsObject = JWSObject.parse((String)Objects.requireNonNull(serializedJwt));
            Optional<JSONObject> jsonPayload = Optional.ofNullable(jwsObject.getPayload()).map(Payload::toJSONObject);
            if (jsonPayload.isPresent()) {
                JWTClaimsSet claims = JWTClaimsSet.parse((JSONObject)jsonPayload.get());
                return Optional.ofNullable(claims.getIssuer());
            }
            return Optional.empty();
        }
        catch (ParseException e) {
            return Optional.empty();
        }
    }

    private void validateRequiredHeaders(JWSObject jwsObject) throws MissingRequiredHeaderException {
        if (jwsObject.getHeader().getAlgorithm() == null || jwsObject.getHeader().getAlgorithm() == Algorithm.NONE) {
            throw new MissingRequiredHeaderException(JwsHeader.Header.ALGORITHM);
        }
        if (jwsObject.getHeader().getKeyID() == null) {
            throw new MissingRequiredHeaderException(JwsHeader.Header.KEY_ID);
        }
    }

    private void validateRequiredClaims(JWTClaimsSet claims) throws MissingRequiredClaimException {
        NimbusJwtParser.checkClaimNotEmpty(claims.getAudience(), JwtClaims.RegisteredClaim.AUDIENCE);
        NimbusJwtParser.checkClaimNotNull(claims.getIssuer(), JwtClaims.RegisteredClaim.ISSUER);
        NimbusJwtParser.checkClaimNotNull(claims.getJWTID(), JwtClaims.RegisteredClaim.JWT_ID);
        NimbusJwtParser.checkClaimNotNull(claims.getIssueTime(), JwtClaims.RegisteredClaim.ISSUED_AT);
        NimbusJwtParser.checkClaimNotNull(claims.getExpirationTime(), JwtClaims.RegisteredClaim.EXPIRY);
    }

    private static void checkClaimNotNull(Object claimValue, JwtClaims.RegisteredClaim claim) throws MissingRequiredClaimException {
        if (claimValue == null) {
            throw new MissingRequiredClaimException(claim);
        }
    }

    private static void checkClaimNotEmpty(Collection claimValue, JwtClaims.RegisteredClaim claim) throws MissingRequiredClaimException {
        if (claimValue == null || claimValue.isEmpty()) {
            throw new MissingRequiredClaimException(claim);
        }
    }
}

