/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.nimbus.parser;

import com.atlassian.asap.core.serializer.Json;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

class NimbusJsr353Translator {
    NimbusJsr353Translator() {
    }

    static JsonValue nimbusToJsr353(Object nimbusObject) {
        if (nimbusObject instanceof JSONObject) {
            return NimbusJsr353Translator.convertObject((JSONObject)nimbusObject);
        }
        if (nimbusObject instanceof JSONArray) {
            return NimbusJsr353Translator.convertArray((JSONArray)nimbusObject);
        }
        if (nimbusObject instanceof Boolean) {
            return (Boolean)nimbusObject != false ? JsonValue.TRUE : JsonValue.FALSE;
        }
        if (nimbusObject == null) {
            return JsonValue.NULL;
        }
        if (nimbusObject instanceof String) {
            throw new RuntimeException("Cannot convert string values at the root level");
        }
        if (nimbusObject instanceof Number) {
            throw new RuntimeException("Cannot convert numeric values at the root level");
        }
        throw new IllegalStateException("Broken JSON, type " + nimbusObject.getClass());
    }

    private static JsonValue convertArray(JSONArray nimbusObject) {
        JsonArrayBuilder arrayBuilder = Json.provider().createArrayBuilder();
        for (Object arrayItem : nimbusObject) {
            if (arrayItem instanceof String) {
                arrayBuilder.add((String)arrayItem);
                continue;
            }
            if (arrayItem instanceof Integer) {
                arrayBuilder.add(((Integer)arrayItem).intValue());
                continue;
            }
            if (arrayItem instanceof Long) {
                arrayBuilder.add(((Long)arrayItem).longValue());
                continue;
            }
            if (arrayItem instanceof Double) {
                arrayBuilder.add(((Double)arrayItem).doubleValue());
                continue;
            }
            if (arrayItem instanceof BigInteger) {
                arrayBuilder.add((BigInteger)arrayItem);
                continue;
            }
            if (arrayItem instanceof BigDecimal) {
                arrayBuilder.add((BigDecimal)arrayItem);
                continue;
            }
            arrayBuilder.add(NimbusJsr353Translator.nimbusToJsr353(arrayItem));
        }
        return arrayBuilder.build();
    }

    private static JsonValue convertObject(JSONObject nimbusObject) {
        JsonObjectBuilder objectBuilder = Json.provider().createObjectBuilder();
        for (Map.Entry entry : nimbusObject.entrySet()) {
            if (entry.getValue() instanceof String) {
                objectBuilder.add((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof Integer) {
                objectBuilder.add((String)entry.getKey(), ((Integer)entry.getValue()).intValue());
                continue;
            }
            if (entry.getValue() instanceof Long) {
                objectBuilder.add((String)entry.getKey(), ((Long)entry.getValue()).longValue());
                continue;
            }
            if (entry.getValue() instanceof Double) {
                objectBuilder.add((String)entry.getKey(), ((Double)entry.getValue()).doubleValue());
                continue;
            }
            if (entry.getValue() instanceof BigInteger) {
                objectBuilder.add((String)entry.getKey(), (BigInteger)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof BigDecimal) {
                objectBuilder.add((String)entry.getKey(), (BigDecimal)entry.getValue());
                continue;
            }
            objectBuilder.add((String)entry.getKey(), NimbusJsr353Translator.nimbusToJsr353(entry.getValue()));
        }
        return objectBuilder.build();
    }
}

