/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.validator;

import com.atlassian.asap.core.exception.InvalidHeaderException;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidatedKeyId {
    public static final Pattern PATH_PATTERN = Pattern.compile("^[\\w.\\-\\+/]*$");
    private static final Set<String> PATH_TRAVERSAL_COMPONENTS = ImmutableSet.of((Object)".", (Object)"..");
    private static final Pattern PATH_SPLITTER = Pattern.compile("/");
    private static final Logger logger = LoggerFactory.getLogger(ValidatedKeyId.class);
    private final String keyId;

    private ValidatedKeyId(String validatedKeyId) {
        this.keyId = Objects.requireNonNull(validatedKeyId);
    }

    public static ValidatedKeyId validate(String unvalidatedKeyId) throws InvalidHeaderException {
        if (StringUtils.isBlank((CharSequence)unvalidatedKeyId)) {
            logger.debug("Rejecting absent or blank kid");
            throw new InvalidHeaderException("The kid header is required");
        }
        List pathComponents = PATH_SPLITTER.splitAsStream(unvalidatedKeyId).map(StringUtils::trim).collect(Collectors.toList());
        if (pathComponents.stream().anyMatch(PATH_TRAVERSAL_COMPONENTS::contains)) {
            logger.debug("Rejecting kid value {} because it contains path traversal", (Object)unvalidatedKeyId);
            throw new InvalidHeaderException("Path traversal components not allowed in kid");
        }
        if (pathComponents.stream().anyMatch(StringUtils::isBlank)) {
            logger.debug("Rejecting kid value {} because it is in invalid format", (Object)unvalidatedKeyId);
            throw new InvalidHeaderException("Invalid format of kid");
        }
        if (!PATH_PATTERN.matcher(unvalidatedKeyId).matches()) {
            logger.debug("Rejecting kid value {} because it contains invalid characters", (Object)unvalidatedKeyId);
            throw new InvalidHeaderException("Invalid character found in kid");
        }
        return new ValidatedKeyId(unvalidatedKeyId);
    }

    public String getKeyId() {
        return this.keyId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidatedKeyId that = (ValidatedKeyId)o;
        return new EqualsBuilder().append((Object)this.keyId, (Object)that.keyId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.keyId).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("keyId", (Object)this.keyId).toString();
    }
}

