/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.keys.publickey;

import com.google.common.base.Preconditions;
import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.protocol.HttpContext;

public class S3ServiceUnavailableRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private final int maxRetries;
    private final long retryInterval;

    public S3ServiceUnavailableRetryStrategy(int maxRetries, long retryInterval) {
        Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0, (Object)"maxRetries must be non-negative");
        Preconditions.checkArgument((retryInterval >= 0L ? 1 : 0) != 0, (Object)"retryInterval must be non-negative");
        this.maxRetries = maxRetries;
        this.retryInterval = retryInterval;
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        return response.getStatusLine().getStatusCode() / 100 == 5 && executionCount <= this.maxRetries;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }
}

