/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.keys.publickey;

import com.atlassian.asap.api.exception.CannotRetrieveKeyException;
import com.atlassian.asap.core.exception.PublicKeyNotFoundException;
import com.atlassian.asap.core.keys.KeyProvider;
import com.atlassian.asap.core.validator.ValidatedKeyId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirroredKeyProvider
implements KeyProvider<PublicKey> {
    private static final Logger logger = LoggerFactory.getLogger(MirroredKeyProvider.class);
    private final List<KeyProvider<PublicKey>> mirrors;

    @VisibleForTesting
    MirroredKeyProvider(List<KeyProvider<PublicKey>> mirrors) {
        this.mirrors = ImmutableList.copyOf(mirrors);
    }

    public static KeyProvider<PublicKey> createMirroredKeyProvider(List<KeyProvider<PublicKey>> mirrors) {
        if (mirrors.size() == 1) {
            return mirrors.get(0);
        }
        return new MirroredKeyProvider(mirrors);
    }

    @Override
    public PublicKey getKey(ValidatedKeyId validatedKeyId) throws CannotRetrieveKeyException {
        Iterator<KeyProvider<PublicKey>> keyProviderIterator = this.mirrors.iterator();
        while (keyProviderIterator.hasNext()) {
            try {
                return keyProviderIterator.next().getKey(validatedKeyId);
            }
            catch (PublicKeyNotFoundException ex) {
                throw ex;
            }
            catch (CannotRetrieveKeyException ex) {
                if (keyProviderIterator.hasNext()) {
                    logger.debug("Error communicating with a key provider, going to try next mirror", (Throwable)ex);
                    continue;
                }
                logger.warn("Error communicating with all mirrored key providers: {}", this.mirrors, (Object)ex);
                throw new CannotRetrieveKeyException("Error communicating with all key providers", ex);
            }
        }
        throw new CannotRetrieveKeyException("There are no mirrors available");
    }

    public List<KeyProvider<PublicKey>> getMirrors() {
        return this.mirrors;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.mirrors + '}';
    }
}

