/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.keys.publickey;

import com.atlassian.asap.api.exception.CannotRetrieveKeyException;
import com.atlassian.asap.core.exception.PublicKeyRetrievalException;
import com.atlassian.asap.core.keys.KeyProvider;
import com.atlassian.asap.core.keys.PemReader;
import com.atlassian.asap.core.keys.publickey.S3ServiceUnavailableRetryStrategy;
import com.atlassian.asap.core.validator.ValidatedKeyId;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.impl.client.cache.CachingHttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPublicKeyProvider
implements KeyProvider<PublicKey> {
    static final int DEFAULT_MAX_CONNECTIONS = 20;
    static final String PEM_MIME_TYPE = "application/x-pem-file";
    static final String ACCEPT_HEADER_VALUE = "application/x-pem-file";
    private static final Logger logger = LoggerFactory.getLogger(HttpPublicKeyProvider.class);
    private final HttpClient httpClient;
    private final PemReader pemReader;
    private final URI baseUrl;

    public HttpPublicKeyProvider(URI baseUrl, HttpClient httpClient, PemReader pemReader) {
        this(baseUrl, httpClient, pemReader, false);
    }

    HttpPublicKeyProvider(URI baseUrl, HttpClient httpClient, PemReader pemReader, boolean allowInsecureConnections) {
        Objects.requireNonNull(baseUrl, "Base URL cannot be null");
        Preconditions.checkArgument((boolean)baseUrl.isAbsolute(), (Object)"Base URL must be absolute");
        Preconditions.checkArgument((allowInsecureConnections && "http".equals(baseUrl.getScheme()) || "https".equals(baseUrl.getScheme()) ? 1 : 0) != 0, (Object)"Invalid base URL scheme");
        Preconditions.checkArgument((boolean)StringUtils.endsWith((CharSequence)baseUrl.toString(), (CharSequence)"/"), (Object)("Base URL does not end with trailing slash: " + baseUrl));
        this.baseUrl = baseUrl;
        this.httpClient = Objects.requireNonNull(httpClient);
        this.pemReader = Objects.requireNonNull(pemReader);
    }

    /*
     * Exception decompiling
     */
    @Override
    public PublicKey getKey(ValidatedKeyId validatedKeyId) throws CannotRetrieveKeyException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PublicKey readEntityAsPublicKey(ValidatedKeyId validatedKeyId, URI keyUrl, HttpEntity entity) throws IOException, CannotRetrieveKeyException {
        Throwable throwable = null;
        try (InputStreamReader reader = new InputStreamReader(entity.getContent(), this.getCharset(entity));){
            String mimeType = ContentType.get((HttpEntity)entity).getMimeType();
            if (Objects.equals("application/x-pem-file", mimeType)) {
                PublicKey publicKey = this.pemReader.readPublicKey(reader);
                return publicKey;
            }
            try {
                throw new PublicKeyRetrievalException(String.format("Unexpected public key MIME type %s, expected %s", mimeType, "application/x-pem-file"), validatedKeyId, keyUrl);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private Charset getCharset(HttpEntity entity) {
        return Optional.ofNullable(ContentType.getOrDefault((HttpEntity)entity).getCharset()).orElse(StandardCharsets.US_ASCII);
    }

    private HttpResponse httpGetKey(URI keyUrl) throws IOException {
        HttpGet httpGet = new HttpGet(keyUrl);
        httpGet.setHeader("Accept", "application/x-pem-file");
        return this.httpClient.execute((HttpUriRequest)httpGet);
    }

    public static HttpClient defaultHttpClient() {
        return HttpPublicKeyProvider.defaultHttpClientBuilder().build();
    }

    public static HttpClientBuilder defaultHttpClientBuilder() {
        return HttpPublicKeyProvider.configureHttpClientBuilder(CachingHttpClients.custom());
    }

    public static HttpClientBuilder configureHttpClientBuilder(CachingHttpClientBuilder httpClientBuilder) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(20);
        connectionManager.setMaxTotal(20);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setConnectionRequestTimeout((int)TimeUnit.SECONDS.toMillis(5L));
        requestConfigBuilder.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(5L));
        requestConfigBuilder.setSocketTimeout((int)TimeUnit.SECONDS.toMillis(10L));
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(128).setMaxObjectSize(2048L).setHeuristicCachingEnabled(false).setSharedCache(false).setAsynchronousWorkersMax(2).build();
        return httpClientBuilder.setCacheConfig(cacheConfig).setDefaultRequestConfig(requestConfigBuilder.build()).setConnectionManager((HttpClientConnectionManager)connectionManager).useSystemProperties().setRedirectStrategy((RedirectStrategy)DefaultRedirectStrategy.INSTANCE).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new S3ServiceUnavailableRetryStrategy(2, 100L));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{baseUrl=" + this.baseUrl + '}';
    }
}

