/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.keys.publickey;

import com.atlassian.asap.api.exception.CannotRetrieveKeyException;
import com.atlassian.asap.core.exception.PublicKeyNotFoundException;
import com.atlassian.asap.core.exception.PublicKeyRetrievalException;
import com.atlassian.asap.core.keys.KeyProvider;
import com.atlassian.asap.core.keys.PemReader;
import com.atlassian.asap.core.validator.ValidatedKeyId;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePublicKeyProvider
implements KeyProvider<PublicKey> {
    private static final Logger logger = LoggerFactory.getLogger(FilePublicKeyProvider.class);
    private final File baseDirectory;
    private final PemReader pemReader;

    public FilePublicKeyProvider(File baseDirectory, PemReader pemReader) {
        this.baseDirectory = Objects.requireNonNull(baseDirectory);
        this.pemReader = Objects.requireNonNull(pemReader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PublicKey getKey(ValidatedKeyId validatedKeyId) throws CannotRetrieveKeyException {
        File file = new File(this.baseDirectory, validatedKeyId.getKeyId());
        logger.debug("Reading public key from file system: {}", (Object)file);
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.US_ASCII);){
            PublicKey publicKey = this.pemReader.readPublicKey(reader);
            return publicKey;
        }
        catch (FileNotFoundException e) {
            logger.debug("Public key file path {} was not found or it is not a file", (Object)file);
            throw new PublicKeyNotFoundException("Public key file path was not found or it is not a file", validatedKeyId, file.toURI());
        }
        catch (CannotRetrieveKeyException | IOException e) {
            logger.warn("A problem occurred when trying to retrieve public key from file: {}", (Object)file, (Object)e);
            throw new PublicKeyRetrievalException("Error reading public key from file", validatedKeyId, file.toURI());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

