/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.keys.privatekey;

import com.atlassian.asap.api.exception.CannotRetrieveKeyException;
import com.atlassian.asap.core.keys.KeyProvider;
import com.atlassian.asap.core.keys.KeyReader;
import com.atlassian.asap.core.validator.ValidatedKeyId;
import java.io.StringReader;
import java.security.PrivateKey;
import java.util.Objects;
import java.util.Optional;

public class StringPrivateKeyProvider
implements KeyProvider<PrivateKey> {
    private final String keyId;
    private final Optional<PrivateKey> privateKey;

    public StringPrivateKeyProvider(KeyReader keyReader, String key, String keyId) {
        this.keyId = Objects.requireNonNull(keyId);
        this.privateKey = StringPrivateKeyProvider.tryReadPrivateKey(keyReader, key);
    }

    private static Optional<PrivateKey> tryReadPrivateKey(KeyReader keyReader, String key) {
        try {
            return Optional.of(keyReader.readPrivateKey(new StringReader(key)));
        }
        catch (CannotRetrieveKeyException e) {
            return Optional.empty();
        }
    }

    @Override
    public PrivateKey getKey(ValidatedKeyId keyId) throws CannotRetrieveKeyException {
        if (keyId.getKeyId().equals(this.keyId)) {
            return this.privateKey.orElseThrow(() -> new CannotRetrieveKeyException("Cannot parse private key"));
        }
        throw new CannotRetrieveKeyException("Cannot find private key");
    }
}

