/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.keys.privatekey;

import com.atlassian.asap.core.keys.DataUriKeyReader;
import com.atlassian.asap.core.keys.KeyProvider;
import com.atlassian.asap.core.keys.PemReader;
import com.atlassian.asap.core.keys.privatekey.ClasspathPrivateKeyProvider;
import com.atlassian.asap.core.keys.privatekey.DataUriKeyProvider;
import com.atlassian.asap.core.keys.privatekey.EnvironmentVariableKeyProvider;
import com.atlassian.asap.core.keys.privatekey.FilePrivateKeyProvider;
import com.atlassian.asap.core.keys.privatekey.NullKeyProvider;
import com.atlassian.asap.core.keys.privatekey.SystemPropertyKeyProvider;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.URI;
import java.security.PrivateKey;

public class PrivateKeyProviderFactory {
    public static KeyProvider<PrivateKey> createPrivateKeyProvider(URI privateKeyPath) {
        return PrivateKeyProviderFactory.createPrivateKeyProvider(privateKeyPath, new EnvironmentVariableKeyProvider.Environment());
    }

    @VisibleForTesting
    static KeyProvider<PrivateKey> createPrivateKeyProvider(URI privateKeyPath, EnvironmentVariableKeyProvider.Environment environment) {
        switch (privateKeyPath.getScheme()) {
            case "file": {
                return new FilePrivateKeyProvider(new File(privateKeyPath), new PemReader());
            }
            case "classpath": {
                return new ClasspathPrivateKeyProvider(privateKeyPath.getPath(), new PemReader());
            }
            case "data": {
                return new DataUriKeyProvider(privateKeyPath, new DataUriKeyReader());
            }
            case "sysprop": {
                return SystemPropertyKeyProvider.fromUri(privateKeyPath, new DataUriKeyReader());
            }
            case "env": {
                return EnvironmentVariableKeyProvider.fromUri(privateKeyPath, new DataUriKeyReader(), environment);
            }
            case "null": {
                return new NullKeyProvider();
            }
        }
        throw new IllegalArgumentException("Unsupported private key base URL: " + privateKeyPath);
    }
}

