/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.keys.privatekey;

import com.atlassian.asap.api.exception.CannotRetrieveKeyException;
import com.atlassian.asap.core.keys.KeyProvider;
import com.atlassian.asap.core.keys.KeyReader;
import com.atlassian.asap.core.validator.ValidatedKeyId;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePrivateKeyProvider
implements KeyProvider<PrivateKey> {
    private static final Logger logger = LoggerFactory.getLogger(FilePrivateKeyProvider.class);
    private final File baseDirectory;
    private final KeyReader keyReader;

    public FilePrivateKeyProvider(File baseDirectory, KeyReader keyReader) {
        this.baseDirectory = Objects.requireNonNull(baseDirectory);
        this.keyReader = Objects.requireNonNull(keyReader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PrivateKey getKey(ValidatedKeyId validatedKeyId) throws CannotRetrieveKeyException {
        File file = new File(this.baseDirectory, validatedKeyId.getKeyId());
        logger.debug("Reading private key from file system: {}", (Object)validatedKeyId.getKeyId());
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.US_ASCII);){
            PrivateKey privateKey = this.keyReader.readPrivateKey(reader);
            return privateKey;
        }
        catch (FileNotFoundException e) {
            logger.debug("Private key file path {} does not exist or is not a file", (Object)file);
            throw new CannotRetrieveKeyException("Private key file path does not exist or is not a file");
        }
        catch (IOException e) {
            throw new CannotRetrieveKeyException(String.format("Error retrieving private key from file: '%s'", file), e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

