/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.keys.privatekey;

import com.atlassian.asap.core.keys.DataUriKeyReader;
import com.atlassian.asap.core.keys.privatekey.DataUriKeyProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EnvironmentVariableKeyProvider
extends DataUriKeyProvider {
    static final String URL_SCHEME = "env";
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentVariableKeyProvider.class);

    @VisibleForTesting
    EnvironmentVariableKeyProvider(String variableName, DataUriKeyReader keyReader, Environment environment) {
        super(EnvironmentVariableKeyProvider.getDataUriFromEnvironment(variableName, environment), keyReader);
    }

    private static URI getDataUriFromEnvironment(String variableName, Environment environment) {
        logger.debug("Reading private key from environment variable {}", (Object)variableName);
        String environmentVariableValue = environment.getVariable(variableName).orElseThrow(() -> new IllegalArgumentException("Undefined environment variable: " + variableName));
        try {
            return new URI(environmentVariableValue);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Value of environment variable " + variableName + " cannot be parsed as a URI");
        }
    }

    public static EnvironmentVariableKeyProvider fromUri(URI uri, DataUriKeyReader keyReader) {
        return EnvironmentVariableKeyProvider.fromUri(uri, keyReader, new Environment());
    }

    @VisibleForTesting
    static EnvironmentVariableKeyProvider fromUri(URI uri, DataUriKeyReader keyReader, Environment environment) {
        Preconditions.checkArgument((boolean)uri.isAbsolute(), (Object)"URL must be absolute");
        Preconditions.checkArgument((boolean)URL_SCHEME.equals(uri.getScheme()), (Object)"URL must have env scheme");
        Preconditions.checkArgument((uri.getPath() != null && uri.getPath().startsWith("/") ? 1 : 0) != 0, (Object)"URL must have a path component");
        Preconditions.checkArgument((uri.getQuery() == null ? 1 : 0) != 0, (Object)"URL must not have a query component");
        Preconditions.checkArgument((uri.getAuthority() == null ? 1 : 0) != 0, (Object)"URL must not have an authority component");
        String basePropertyName = uri.getPath().substring(1);
        return new EnvironmentVariableKeyProvider(basePropertyName, keyReader, environment);
    }

    static class Environment {
        Environment() {
        }

        public Optional<String> getVariable(String name) {
            return Optional.ofNullable(System.getenv(name));
        }
    }
}

