/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.keys.privatekey;

import com.atlassian.asap.api.exception.CannotRetrieveKeyException;
import com.atlassian.asap.core.keys.DataUriKeyReader;
import com.atlassian.asap.core.keys.DataUriUtil;
import com.atlassian.asap.core.keys.KeyProvider;
import com.atlassian.asap.core.validator.ValidatedKeyId;
import com.google.common.base.Preconditions;
import java.io.StringReader;
import java.net.URI;
import java.security.PrivateKey;

public class DataUriKeyProvider
implements KeyProvider<PrivateKey> {
    static final String URI_SCHEME = "data";
    private final String dataUriKeyId;
    private final PrivateKey privateKey;

    public DataUriKeyProvider(URI dataUri, DataUriKeyReader dataUriKeyReader) {
        Preconditions.checkArgument((boolean)dataUri.isAbsolute(), (Object)"URI must be absolute");
        Preconditions.checkArgument((boolean)dataUri.isOpaque(), (Object)"URI must not have path components");
        Preconditions.checkArgument((boolean)URI_SCHEME.equals(dataUri.getScheme()), (Object)"URI must have data scheme");
        this.dataUriKeyId = DataUriUtil.getKeyId(dataUri.toString());
        this.privateKey = DataUriKeyProvider.getKeyFromDataUri(dataUri, dataUriKeyReader);
    }

    @Override
    public PrivateKey getKey(ValidatedKeyId keyId) throws CannotRetrieveKeyException {
        if (this.dataUriKeyId.equals(keyId.getKeyId())) {
            return this.privateKey;
        }
        throw new CannotRetrieveKeyException("Unrecognized key id: " + keyId.getKeyId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PrivateKey getKeyFromDataUri(URI dataUri, DataUriKeyReader keyReader) {
        try (StringReader reader = new StringReader(dataUri.toString());){
            PrivateKey privateKey = keyReader.readPrivateKey(reader);
            return privateKey;
        }
        catch (CannotRetrieveKeyException ex) {
            throw new IllegalArgumentException("Unable to parse key from data uri", ex);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

