/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.keys;

import com.atlassian.asap.api.exception.CannotRetrieveKeyException;
import com.atlassian.asap.core.SecurityProvider;
import com.atlassian.asap.core.keys.KeyReader;
import java.io.IOException;
import java.io.Reader;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.encoders.DecoderException;

public class PemReader
implements KeyReader {
    private final Provider provider;

    public PemReader() {
        this(SecurityProvider.getProvider());
    }

    public PemReader(Provider provider) {
        this.provider = provider;
    }

    @Override
    public PrivateKey readPrivateKey(Reader reader) throws CannotRetrieveKeyException {
        try {
            PEMParser pemParser = new PEMParser(reader);
            Object keyPairObject = pemParser.readObject();
            if (keyPairObject instanceof PEMKeyPair) {
                PEMKeyPair pemKeyPair = (PEMKeyPair)keyPairObject;
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(this.provider);
                return converter.getPrivateKey(pemKeyPair.getPrivateKeyInfo());
            }
            throw new CannotRetrieveKeyException("Error reading PEM private key, unknown key pair object type");
        }
        catch (IOException | DecoderException e) {
            throw new CannotRetrieveKeyException("Error reading PEM private key", e);
        }
    }

    @Override
    public PublicKey readPublicKey(Reader reader) throws CannotRetrieveKeyException {
        try {
            PEMParser pemParser = new PEMParser(reader);
            Object object = pemParser.readObject();
            SubjectPublicKeyInfo pub = SubjectPublicKeyInfo.getInstance((Object)object);
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(this.provider);
            return converter.getPublicKey(pub);
        }
        catch (IOException | DecoderException e) {
            throw new CannotRetrieveKeyException("Error reading PEM public key", e);
        }
    }
}

