/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.keys;

import com.atlassian.asap.api.exception.CannotRetrieveKeyException;
import com.atlassian.asap.core.SecurityProvider;
import com.atlassian.asap.core.keys.DataUriUtil;
import com.atlassian.asap.core.keys.KeyReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class DataUriKeyReader
implements KeyReader {
    public static final String DATA_URI_PKCS8_HEADER = "data:application/pkcs8;";
    public static final String DATA_URI_PEM_HEADER = "data:application/x-pem-file;";
    private final Provider provider;

    public DataUriKeyReader() {
        this(SecurityProvider.getProvider());
    }

    public DataUriKeyReader(Provider provider) {
        this.provider = provider;
    }

    @Override
    public PrivateKey readPrivateKey(Reader reader) throws CannotRetrieveKeyException {
        try {
            String dataUri = IOUtils.toString((Reader)reader);
            if (dataUri.startsWith(DATA_URI_PKCS8_HEADER)) {
                byte[] keyData = DataUriUtil.getKeyData(dataUri);
                AlgorithmIdentifier algorithmIdentifier = PrivateKeyInfo.getInstance((Object)keyData).getPrivateKeyAlgorithm();
                KeyFactory keyFactory = KeyFactory.getInstance(algorithmIdentifier.getAlgorithm().getId(), this.provider);
                return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyData));
            }
            throw new CannotRetrieveKeyException("Data uri could not be parsed due to unexpected prefix");
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new CannotRetrieveKeyException("Error reading private key, unknown key type", e);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new CannotRetrieveKeyException("Error reading private key", e);
        }
    }

    @Override
    public PublicKey readPublicKey(Reader reader) throws CannotRetrieveKeyException {
        try {
            String dataUri = IOUtils.toString((Reader)reader);
            if (dataUri.startsWith(DATA_URI_PEM_HEADER)) {
                byte[] keyData = DataUriUtil.getKeyData(dataUri);
                PEMParser pemParser = new PEMParser((Reader)new StringReader(new String(keyData, StandardCharsets.US_ASCII)));
                SubjectPublicKeyInfo pub = SubjectPublicKeyInfo.getInstance((Object)pemParser.readObject());
                JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(this.provider);
                return converter.getPublicKey(pub);
            }
            throw new CannotRetrieveKeyException("Data uri could not be parsed due to unexpected prefix");
        }
        catch (IOException | IllegalArgumentException e) {
            throw new CannotRetrieveKeyException("Error reading Public key", e);
        }
    }
}

