/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.keys;

import com.atlassian.asap.api.exception.CannotRetrieveKeyException;
import com.atlassian.asap.core.exception.PublicKeyNotFoundException;
import com.atlassian.asap.core.keys.KeyProvider;
import com.atlassian.asap.core.validator.ValidatedKeyId;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.security.Key;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChainedKeyProvider<K extends Key>
implements KeyProvider<K> {
    private static final Logger logger = LoggerFactory.getLogger(com.atlassian.asap.core.keys.publickey.ChainedKeyProvider.class);
    private final List<KeyProvider<K>> keyProviderChain;
    private final Function<ValidatedKeyId, ? extends CannotRetrieveKeyException> exceptionBuilder;

    public ChainedKeyProvider(List<KeyProvider<K>> keyProviderChain, Function<ValidatedKeyId, ? extends CannotRetrieveKeyException> exceptionBuilder) {
        this.keyProviderChain = ImmutableList.copyOf(keyProviderChain);
        this.exceptionBuilder = Objects.requireNonNull(exceptionBuilder);
    }

    public static <K extends Key> KeyProvider<K> createChainedKeyProvider(List<KeyProvider<K>> keyProviderChain) {
        if (keyProviderChain.size() == 1) {
            return keyProviderChain.get(0);
        }
        return new ChainedKeyProvider<K>(keyProviderChain, keyId -> new CannotRetrieveKeyException(String.format("None of the chained key providers contains the key: %s", keyId.getKeyId())));
    }

    @Override
    public K getKey(ValidatedKeyId validatedKeyId) throws CannotRetrieveKeyException {
        if (this.keyProviderChain.isEmpty()) {
            throw new CannotRetrieveKeyException("There are no key providers available in the chain");
        }
        Iterator<KeyProvider<K>> keyProviderIterator = this.keyProviderChain.iterator();
        CannotRetrieveKeyException firstError = null;
        LinkedList failingProviders = Lists.newLinkedList();
        while (keyProviderIterator.hasNext()) {
            KeyProvider<K> keyProvider = keyProviderIterator.next();
            try {
                return keyProvider.getKey(validatedKeyId);
            }
            catch (PublicKeyNotFoundException ex) {
                logger.debug("Key not found in the provider {}, continuing with the next provider in the chain", keyProvider);
            }
            catch (CannotRetrieveKeyException ex) {
                failingProviders.add(keyProvider);
                if (firstError == null) {
                    firstError = ex;
                }
                logger.debug("Error retrieving key from the provider {}, continuing with the next provider in the chain", keyProvider, (Object)ex);
            }
        }
        if (firstError != null) {
            logger.warn("Unable to retrieve key from chained key providers: {}. Showing first error.", (Object)failingProviders, firstError);
            throw new CannotRetrieveKeyException("Unable to retrieve key from chained key providers. " + failingProviders.size() + " provider(s) could not be contacted. Chaining first error.", firstError);
        }
        logger.debug("None of the chained key providers contains the key: {}", this.keyProviderChain);
        throw this.exceptionBuilder.apply(validatedKeyId);
    }

    public List<KeyProvider<K>> getKeyProviderChain() {
        return this.keyProviderChain;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.keyProviderChain + '}';
    }
}

