/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.api.exception;

import com.atlassian.asap.core.validator.ValidatedKeyId;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CannotRetrieveKeyException
extends Exception {
    @Nullable
    private final transient ValidatedKeyId keyId;
    @Nullable
    private final URI keyUri;

    public CannotRetrieveKeyException(String reason) {
        this(reason, (URI)null);
    }

    public CannotRetrieveKeyException(String reason, URI keyUri) {
        this(reason, (ValidatedKeyId)null, keyUri);
    }

    public CannotRetrieveKeyException(String reason, ValidatedKeyId keyId) {
        this(reason, keyId, null);
    }

    public CannotRetrieveKeyException(String reason, ValidatedKeyId keyId, URI keyUri) {
        super(reason);
        this.keyId = keyId;
        this.keyUri = keyUri;
    }

    public CannotRetrieveKeyException(String message, Throwable cause) {
        this(message, cause, null);
    }

    public CannotRetrieveKeyException(String message, Throwable cause, URI keyUri) {
        this(message, cause, null, keyUri);
    }

    protected CannotRetrieveKeyException(String message, Throwable cause, ValidatedKeyId keyId, URI keyUri) {
        super(message, cause);
        this.keyId = keyId;
        this.keyUri = keyUri;
    }

    @Nonnull
    public final Optional<ValidatedKeyId> getKeyId() {
        return Optional.ofNullable(this.keyId);
    }

    @Nonnull
    public final Optional<URI> getKeyUri() {
        return Optional.ofNullable(this.keyUri);
    }
}

