/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.api.exception;

import com.atlassian.asap.core.validator.ValidatedKeyId;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Nullable;

public abstract class AuthenticationFailedException
extends Exception {
    @Nullable
    private final ValidatedKeyId keyId;
    @Nullable
    private final URI keyUri;
    @Nullable
    private final String unverifiedIssuer;

    protected AuthenticationFailedException(String message, String unverifiedIssuer) {
        this(message, null, null, unverifiedIssuer);
    }

    protected AuthenticationFailedException(String message, ValidatedKeyId keyId, URI keyUri, String unverifiedIssuer) {
        super(message);
        this.keyId = keyId;
        this.keyUri = keyUri;
        this.unverifiedIssuer = unverifiedIssuer;
    }

    public Optional<ValidatedKeyId> getKeyId() {
        return Optional.ofNullable(this.keyId);
    }

    public Optional<URI> getKeyUri() {
        return Optional.ofNullable(this.keyUri);
    }

    public Optional<String> getUnverifiedIssuer() {
        return Optional.ofNullable(this.unverifiedIssuer);
    }
}

