/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.api;

import com.atlassian.asap.api.JwsHeader;
import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.api.JwtClaims;
import com.atlassian.asap.api.SigningAlgorithm;
import com.atlassian.asap.core.serializer.Json;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class JwtBuilder {
    public static final Duration DEFAULT_LIFETIME = Duration.ofSeconds(60L);
    public static final SigningAlgorithm DEFAULT_ALGORITHM = SigningAlgorithm.RS256;
    private SigningAlgorithm alg;
    private String keyId;
    private String iss;
    private Optional<String> sub;
    private List<String> aud;
    private Instant iat;
    private Instant exp;
    private Optional<Instant> nbf;
    private String jti;
    private JsonObject customClaims;

    private JwtBuilder() {
        Instant now = Instant.now();
        this.notBefore(Optional.of(now));
        this.issuedAt(now);
        this.expirationTime(now.plus(DEFAULT_LIFETIME));
        this.jwtId(UUID.randomUUID().toString());
        this.algorithm(DEFAULT_ALGORITHM);
        this.sub = Optional.empty();
        this.customClaims = Json.provider().createObjectBuilder().build();
    }

    public static JwtBuilder newJwt() {
        return new JwtBuilder();
    }

    public static JwtBuilder newFromPrototype(Jwt jwtPrototype) {
        Instant now = Instant.now();
        return JwtBuilder.copyJwt(jwtPrototype).notBefore(Optional.of(now)).issuedAt(now).expirationTime(now.plus(DEFAULT_LIFETIME)).jwtId(UUID.randomUUID().toString());
    }

    public static JwtBuilder copyJwt(Jwt prototype) {
        return new JwtBuilder().algorithm(prototype.getHeader().getAlgorithm()).keyId(prototype.getHeader().getKeyId()).issuer(prototype.getClaims().getIssuer()).subject(prototype.getClaims().getSubject()).audience(prototype.getClaims().getAudience()).issuedAt(prototype.getClaims().getIssuedAt()).expirationTime(prototype.getClaims().getExpiry()).notBefore(prototype.getClaims().getNotBefore()).jwtId(prototype.getClaims().getJwtId()).customClaims(prototype.getClaims().getJson());
    }

    public JwtBuilder keyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    public JwtBuilder algorithm(SigningAlgorithm alg) {
        this.alg = alg;
        return this;
    }

    public JwtBuilder audience(Iterable<String> aud) {
        this.aud = ImmutableList.copyOf(aud);
        return this;
    }

    public JwtBuilder audience(String ... aud) {
        this.aud = ImmutableList.copyOf((Object[])aud);
        return this;
    }

    public JwtBuilder expirationTime(Instant expiry) {
        this.exp = expiry;
        return this;
    }

    public JwtBuilder issuedAt(Instant iat) {
        this.iat = iat;
        return this;
    }

    public JwtBuilder issuer(String iss) {
        this.iss = iss;
        return this;
    }

    public JwtBuilder jwtId(String jti) {
        this.jti = jti;
        return this;
    }

    public JwtBuilder notBefore(Optional<Instant> nbf) {
        this.nbf = nbf;
        return this;
    }

    public JwtBuilder subject(Optional<String> sub) {
        this.sub = sub;
        return this;
    }

    public JwtBuilder customClaims(JsonObject customClaims) {
        this.customClaims = customClaims;
        return this;
    }

    public Jwt build() {
        ImmutableJwsHeader header = new ImmutableJwsHeader(this.alg, this.keyId);
        JsonObjectBuilder claimsJsonObjectBuilder = Json.provider().createObjectBuilder();
        ImmutableSet optionalRegisteredClaimKeys = ImmutableSet.of((Object)JwtClaims.RegisteredClaim.SUBJECT.key(), (Object)JwtClaims.RegisteredClaim.NOT_BEFORE.key());
        for (Map.Entry entry : this.customClaims.entrySet()) {
            if (optionalRegisteredClaimKeys.contains(entry.getKey())) continue;
            claimsJsonObjectBuilder.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        for (Map.Entry entry : ImmutableJwtClaims.getRegisteredClaims(this.iss, this.sub, this.aud, this.exp, this.nbf, this.iat, this.jti).entrySet()) {
            claimsJsonObjectBuilder.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        ImmutableJwtClaims claims = new ImmutableJwtClaims(claimsJsonObjectBuilder.build());
        return new ImmutableJwt(header, claims);
    }

    private static class ImmutableJwtClaims
    implements JwtClaims,
    Serializable {
        private static final long serialVersionUID = 5227306085811054804L;
        private transient JsonObject claimsJsonObject;

        ImmutableJwtClaims(JsonObject claimsJsonObject) {
            this.claimsJsonObject = Objects.requireNonNull(claimsJsonObject);
        }

        static JsonObject getRegisteredClaims(String iss, Optional<String> sub, List<String> aud, Instant exp, Optional<Instant> nbf, Instant iat, String jti) {
            Objects.requireNonNull(iss, "JWT claim 'iss' cannot be null");
            Objects.requireNonNull(sub, "JWT claim 'sub' cannot be null (but it can be None)");
            Objects.requireNonNull(aud, "JWT claim 'aud' cannot be null");
            Objects.requireNonNull(iat, "JWT claim 'iat' cannot be null");
            Objects.requireNonNull(exp, "JWT claim 'exp' cannot be null");
            Objects.requireNonNull(nbf, "JWT claim 'nbf' cannot be null (but it can be None)");
            Objects.requireNonNull(jti, "JWT claim 'jit' cannot be null");
            JsonObjectBuilder jsonObjectBuilder = Json.provider().createObjectBuilder();
            jsonObjectBuilder.add(JwtClaims.RegisteredClaim.ISSUER.key(), iss);
            jsonObjectBuilder.add(JwtClaims.RegisteredClaim.ISSUED_AT.key(), iat.getEpochSecond());
            jsonObjectBuilder.add(JwtClaims.RegisteredClaim.EXPIRY.key(), exp.getEpochSecond());
            jsonObjectBuilder.add(JwtClaims.RegisteredClaim.JWT_ID.key(), jti);
            sub.ifPresent(s -> jsonObjectBuilder.add(JwtClaims.RegisteredClaim.SUBJECT.key(), s));
            nbf.ifPresent(n -> jsonObjectBuilder.add(JwtClaims.RegisteredClaim.NOT_BEFORE.key(), n.getEpochSecond()));
            if (aud.size() == 1) {
                jsonObjectBuilder.add(JwtClaims.RegisteredClaim.AUDIENCE.key(), aud.iterator().next());
            } else {
                JsonArrayBuilder audienceArrayBuilder = Json.provider().createArrayBuilder();
                aud.forEach(arg_0 -> ((JsonArrayBuilder)audienceArrayBuilder).add(arg_0));
                jsonObjectBuilder.add(JwtClaims.RegisteredClaim.AUDIENCE.key(), audienceArrayBuilder);
            }
            return jsonObjectBuilder.build();
        }

        @Override
        public String getIssuer() {
            return this.claimsJsonObject.getString(JwtClaims.RegisteredClaim.ISSUER.key());
        }

        @Override
        public Optional<String> getSubject() {
            return Optional.ofNullable(this.claimsJsonObject.getString(JwtClaims.RegisteredClaim.SUBJECT.key(), null));
        }

        @Override
        public Set<String> getAudience() {
            JsonValue jsonValue = (JsonValue)this.claimsJsonObject.getOrDefault((Object)JwtClaims.RegisteredClaim.AUDIENCE.key(), (Object)Json.provider().createArrayBuilder().build());
            switch (jsonValue.getValueType()) {
                case ARRAY: {
                    return ((JsonArray)jsonValue).getValuesAs(JsonString.class).stream().map(JsonString::getString).collect(Collectors.toSet());
                }
                case STRING: {
                    return ImmutableSet.of((Object)((JsonString)jsonValue).getString());
                }
            }
            throw new RuntimeException("Unexpected 'aud' claim type");
        }

        @Override
        public Instant getExpiry() {
            return Instant.ofEpochSecond(this.claimsJsonObject.getJsonNumber(JwtClaims.RegisteredClaim.EXPIRY.key()).longValueExact());
        }

        @Override
        public Optional<Instant> getNotBefore() {
            return Optional.ofNullable(this.claimsJsonObject.getJsonNumber(JwtClaims.RegisteredClaim.NOT_BEFORE.key())).map(JsonNumber::longValueExact).map(Instant::ofEpochSecond);
        }

        @Override
        public Instant getIssuedAt() {
            return Instant.ofEpochSecond(this.claimsJsonObject.getJsonNumber(JwtClaims.RegisteredClaim.ISSUED_AT.key()).longValueExact());
        }

        @Override
        public String getJwtId() {
            return this.claimsJsonObject.getString(JwtClaims.RegisteredClaim.JWT_ID.key());
        }

        @Override
        public JsonObject getJson() {
            return this.claimsJsonObject;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(JwtClaims.RegisteredClaim.ISSUER.key(), (Object)this.getIssuer()).append(JwtClaims.RegisteredClaim.SUBJECT.key(), this.getSubject()).append(JwtClaims.RegisteredClaim.AUDIENCE.key(), this.getAudience()).append(JwtClaims.RegisteredClaim.ISSUED_AT.key(), (Object)this.getIssuedAt()).append(JwtClaims.RegisteredClaim.EXPIRY.key(), (Object)this.getExpiry()).append(JwtClaims.RegisteredClaim.NOT_BEFORE.key(), this.getNotBefore()).append(JwtClaims.RegisteredClaim.JWT_ID.key(), (Object)this.getJwtId()).toString();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            ImmutableJwtClaims rhs = (ImmutableJwtClaims)o;
            return this.claimsJsonObject.equals(rhs.claimsJsonObject);
        }

        public int hashCode() {
            return this.claimsJsonObject.hashCode();
        }

        private void readObject(ObjectInputStream inputStream) throws ClassNotFoundException, IOException {
            inputStream.defaultReadObject();
            this.claimsJsonObject = Json.provider().createReader((InputStream)inputStream).readObject();
        }

        private void writeObject(ObjectOutputStream outputStream) throws IOException {
            outputStream.defaultWriteObject();
            Json.provider().createWriter((OutputStream)outputStream).writeObject(this.claimsJsonObject);
        }
    }

    private static final class ImmutableJwsHeader
    implements JwsHeader,
    Serializable {
        private static final long serialVersionUID = -4791575710345791956L;
        private final SigningAlgorithm algorithm;
        private final String keyId;

        ImmutableJwsHeader(SigningAlgorithm algorithm, String keyId) {
            this.algorithm = Objects.requireNonNull(algorithm, "JWT header 'alg' cannot be null");
            this.keyId = Objects.requireNonNull(keyId, "JWT header 'kid' cannot be null");
        }

        @Override
        public String getKeyId() {
            return this.keyId;
        }

        @Override
        public SigningAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append(JwsHeader.Header.ALGORITHM.key(), (Object)this.algorithm).append(JwsHeader.Header.KEY_ID.key(), (Object)this.keyId).toString();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            ImmutableJwsHeader rhs = (ImmutableJwsHeader)o;
            return new EqualsBuilder().append((Object)this.algorithm, (Object)rhs.algorithm).append((Object)this.keyId, (Object)rhs.keyId).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.algorithm).append((Object)this.keyId).hashCode();
        }
    }

    private static class ImmutableJwt
    implements Jwt,
    Serializable {
        private static final long serialVersionUID = 4437693510625284065L;
        private final JwsHeader header;
        private final JwtClaims claimsSet;

        ImmutableJwt(JwsHeader header, JwtClaims claims) {
            this.header = Objects.requireNonNull(header);
            this.claimsSet = Objects.requireNonNull(claims);
        }

        @Override
        public JwsHeader getHeader() {
            return this.header;
        }

        @Override
        public JwtClaims getClaims() {
            return this.claimsSet;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("header", (Object)this.header).append("claims", (Object)this.claimsSet).toString();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            ImmutableJwt rhs = (ImmutableJwt)o;
            return new EqualsBuilder().append((Object)this.header, (Object)rhs.header).append((Object)this.claimsSet, (Object)rhs.claimsSet).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.header).append((Object)this.claimsSet).hashCode();
        }
    }
}

