/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.keys.publickey;

import com.atlassian.asap.core.keys.KeyProvider;
import com.atlassian.asap.core.keys.PemReader;
import com.atlassian.asap.core.keys.publickey.ChainedKeyProvider;
import com.atlassian.asap.core.keys.publickey.FilePublicKeyProvider;
import com.atlassian.asap.core.keys.publickey.HttpPublicKeyProvider;
import com.atlassian.asap.core.keys.publickey.MirroredKeyProvider;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import java.security.PublicKey;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicKeyProviderFactory {
    private static final Pattern CHAIN_SPLITTER_REGEX = Pattern.compile("\\s+,\\s+");
    private static final Pattern MIRRORS_SPLITTER_REGEX = Pattern.compile("\\s+\\|\\s+");
    private static final Logger logger = LoggerFactory.getLogger(HttpPublicKeyProvider.class);
    private final PemReader pemReader;
    private final HttpClient httpClient;

    public PublicKeyProviderFactory(HttpClient httpClient, PemReader pemReader) {
        this.pemReader = Objects.requireNonNull(pemReader);
        this.httpClient = Objects.requireNonNull(httpClient);
    }

    public static PublicKeyProviderFactory createDefault() {
        return new PublicKeyProviderFactory(HttpPublicKeyProvider.defaultHttpClient(), new PemReader());
    }

    public KeyProvider<PublicKey> createPublicKeyProvider(String publicKeyBaseUrl) {
        Objects.requireNonNull(publicKeyBaseUrl);
        logger.info("Using {} as public key base url", (Object)publicKeyBaseUrl);
        return this.parseChainedPublicKeyProviders(publicKeyBaseUrl);
    }

    private KeyProvider<PublicKey> parseChainedPublicKeyProviders(String publicKeyBaseUrl) {
        List<KeyProvider<PublicKey>> keyProviderChain = CHAIN_SPLITTER_REGEX.splitAsStream(publicKeyBaseUrl).map(String::trim).filter(StringUtils::isNotBlank).map(this::parseMirroredPublicKeyProviders).collect(Collectors.toList());
        if (keyProviderChain.isEmpty()) {
            logger.warn("No key providers available, all requests will be rejected.");
        }
        return ChainedKeyProvider.createChainedKeyProvider(keyProviderChain);
    }

    private KeyProvider<PublicKey> parseMirroredPublicKeyProviders(String baseUrlComponent) {
        List<KeyProvider<PublicKey>> mirroredProviders = MIRRORS_SPLITTER_REGEX.splitAsStream(baseUrlComponent).map(String::trim).filter(StringUtils::isNotBlank).map(this::getPublicKeyKeyProvider).collect(Collectors.toList());
        return MirroredKeyProvider.createMirroredKeyProvider(mirroredProviders);
    }

    private KeyProvider<PublicKey> getPublicKeyKeyProvider(String baseUrl) {
        URI parsedBaseUrl = URI.create(baseUrl);
        Preconditions.checkArgument((boolean)parsedBaseUrl.isAbsolute(), (Object)"URL must be absolute");
        Preconditions.checkArgument((!baseUrl.contains(",") ? 1 : 0) != 0, (Object)"Comma must be encoded if present in URI");
        Preconditions.checkArgument((!baseUrl.contains("|") ? 1 : 0) != 0, (Object)"Pipe must be encoded if present in URI");
        switch (parsedBaseUrl.getScheme()) {
            case "https": {
                return new HttpPublicKeyProvider(parsedBaseUrl, this.httpClient, this.pemReader);
            }
            case "file": {
                return new FilePublicKeyProvider(new File(parsedBaseUrl), this.pemReader);
            }
        }
        throw new IllegalArgumentException("Unsupported public key server base URL protocol, only https: and file: are supported: " + parsedBaseUrl);
    }
}

