/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.keys.publickey;

import com.atlassian.asap.api.exception.CannotRetrieveKeyException;
import com.atlassian.asap.core.exception.PublicKeyNotFoundException;
import com.atlassian.asap.core.keys.KeyProvider;
import com.atlassian.asap.core.validator.ValidatedKeyId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainedKeyProvider
implements KeyProvider<PublicKey> {
    private static final Logger logger = LoggerFactory.getLogger(ChainedKeyProvider.class);
    private final List<KeyProvider<PublicKey>> keyProviderChain;

    @VisibleForTesting
    ChainedKeyProvider(List<KeyProvider<PublicKey>> keyProviderChain) {
        this.keyProviderChain = ImmutableList.copyOf(keyProviderChain);
    }

    public static KeyProvider<PublicKey> createChainedKeyProvider(List<KeyProvider<PublicKey>> keyProviderChain) {
        if (keyProviderChain.size() == 1) {
            return keyProviderChain.get(0);
        }
        return new ChainedKeyProvider(keyProviderChain);
    }

    @Override
    public PublicKey getKey(ValidatedKeyId validatedKeyId) throws CannotRetrieveKeyException {
        Iterator<KeyProvider<PublicKey>> keyProviderIterator = this.keyProviderChain.iterator();
        while (keyProviderIterator.hasNext()) {
            try {
                return keyProviderIterator.next().getKey(validatedKeyId);
            }
            catch (PublicKeyNotFoundException ex) {
                if (keyProviderIterator.hasNext()) {
                    logger.debug("Key not found in the provider, going to failover to next provider", (Throwable)ex);
                    continue;
                }
                logger.debug("Error retrieving key from all key providers: {}", this.keyProviderChain, (Object)ex);
                throw new CannotRetrieveKeyException("Error communicating with all key providers", ex);
            }
            catch (CannotRetrieveKeyException ex) {
                if (keyProviderIterator.hasNext()) {
                    logger.debug("Error retrieving key from the provider, going to failover to next provider", (Throwable)ex);
                    continue;
                }
                logger.error("Error retrieving key from all key providers: {}", this.keyProviderChain, (Object)ex);
                throw new CannotRetrieveKeyException("Error communicating with all key providers", ex);
            }
        }
        throw new CannotRetrieveKeyException("There are no key providers available in the chain");
    }

    public List<KeyProvider<PublicKey>> getKeyProviderChain() {
        return this.keyProviderChain;
    }
}

