/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.api;

import com.atlassian.asap.api.AlgorithmType;

public enum SigningAlgorithm {
    RS256(AlgorithmType.RSA, 256),
    RS384(AlgorithmType.RSA, 384),
    RS512(AlgorithmType.RSA, 512),
    ES256(AlgorithmType.ECDSA, 256),
    ES384(AlgorithmType.ECDSA, 384),
    ES512(AlgorithmType.ECDSA, 512),
    PS256(AlgorithmType.RSASSA_PSS, 256),
    PS384(AlgorithmType.RSASSA_PSS, 384),
    PS512(AlgorithmType.RSASSA_PSS, 512);

    private final AlgorithmType type;
    private final int hashSize;

    private SigningAlgorithm(AlgorithmType type, int hashSize) {
        this.type = type;
        this.hashSize = hashSize;
    }

    public AlgorithmType type() {
        return this.type;
    }

    public int hashSize() {
        return this.hashSize;
    }
}

