package com.atlassian.asap.core.parser;

import com.atlassian.asap.core.exception.JwtParseException;
import com.atlassian.asap.core.exception.UnsupportedAlgorithmException;

/**
 * Parses a JWT token without verifying its signature or checking the validity of its claims.
 */
public interface JwtParser
{
    /**
     * Parses the encoded JWT message from {@link String}, and returns a verifiable JWT object without
     * verifying its signature or validating its claims. All the required headers and claims must be present.
     *
     * @param serializedJwt a JSON Web Token
     * @return a {@link VerifiableJwt} that has all the required claims and headers
     * @throws JwtParseException        if the JWT string was malformed (see subclasses)
     * @throws UnsupportedAlgorithmException if the signature algorithm is not recognised
     */
    VerifiableJwt parse(String serializedJwt) throws JwtParseException, UnsupportedAlgorithmException;
}
