package com.atlassian.asap.core.exception;

import com.atlassian.asap.api.exception.CannotRetrieveKeyException;

/**
 * Thrown when there was an error communicating with a public key repository.
 *
 * @see PublicKeyNotFoundException
 */
public class PublicKeyRetrievalException extends CannotRetrieveKeyException
{
    public PublicKeyRetrievalException(String message)
    {
        super(message);
    }

    public PublicKeyRetrievalException(String message, Throwable cause)
    {
        super(message, cause);
    }
}
