package com.atlassian.asap.core.exception;

import com.atlassian.asap.api.exception.CannotRetrieveKeyException;

/**
 * Thrown when the public key is reported as absent from the key repository.
 *
 * @see PublicKeyRetrievalException
 */
public class PublicKeyNotFoundException extends CannotRetrieveKeyException
{
    public PublicKeyNotFoundException(String reason)
    {
        super(reason);
    }

    public PublicKeyNotFoundException(String message, Throwable cause)
    {
        super(message, cause);
    }
}
