package com.atlassian.asap.core.exception;

import com.atlassian.asap.api.JwsHeader;

/**
 * Thrown when a required header is missing in the JWT header.
 */
public class MissingRequiredHeaderException extends JwtParseException
{
    public MissingRequiredHeaderException(JwsHeader.Header missingHeader)
    {
        super("JWT token missing required header: " + missingHeader.key());
    }
}
