package com.atlassian.asap.core.exception;

import com.atlassian.asap.api.JwtClaims;

/**
 * Thrown when a required claim is missing in the JWT claims payload.
 */
public class MissingRequiredClaimException extends JwtParseException
{
    public MissingRequiredClaimException(JwtClaims.Claim claim)
    {
        super("JWT token missing required claim: " + claim.key());
    }
}
