/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.client.http;

import com.atlassian.asap.api.Jwt;
import com.atlassian.asap.api.client.http.AuthorizationHeaderGenerator;
import com.atlassian.asap.api.exception.CannotRetrieveKeyException;
import com.atlassian.asap.api.exception.InvalidTokenException;
import com.atlassian.asap.core.keys.ChainedKeyProvider;
import com.atlassian.asap.core.keys.KeyProvider;
import com.atlassian.asap.core.keys.privatekey.PrivateKeyProviderFactory;
import com.atlassian.asap.core.serializer.JwtSerializer;
import com.atlassian.asap.core.validator.ValidatedKeyId;
import com.atlassian.asap.nimbus.serializer.NimbusJwtSerializer;
import java.net.URI;
import java.security.PrivateKey;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class AuthorizationHeaderGeneratorImpl
implements AuthorizationHeaderGenerator {
    private final JwtSerializer jwtSerializer;
    private final KeyProvider<PrivateKey> privateKeyProvider;

    public AuthorizationHeaderGeneratorImpl(JwtSerializer jwtSerializer, KeyProvider<PrivateKey> privateKeyProvider) {
        this.jwtSerializer = Objects.requireNonNull(jwtSerializer);
        this.privateKeyProvider = Objects.requireNonNull(privateKeyProvider);
    }

    public static AuthorizationHeaderGenerator createDefault(URI privateKeyPath) {
        KeyProvider keyProvider = PrivateKeyProviderFactory.createPrivateKeyProvider((URI)privateKeyPath);
        return new AuthorizationHeaderGeneratorImpl((JwtSerializer)new NimbusJwtSerializer(), (KeyProvider<PrivateKey>)keyProvider);
    }

    public static AuthorizationHeaderGenerator createDefault(URI ... privateKeyPaths) {
        List keyProviders = Stream.of(privateKeyPaths).map(PrivateKeyProviderFactory::createPrivateKeyProvider).collect(Collectors.toList());
        return new AuthorizationHeaderGeneratorImpl((JwtSerializer)new NimbusJwtSerializer(), (KeyProvider<PrivateKey>)ChainedKeyProvider.createChainedKeyProvider(keyProviders));
    }

    public String generateAuthorizationHeader(Jwt jwt) throws InvalidTokenException, CannotRetrieveKeyException {
        ValidatedKeyId validatedKeyId = ValidatedKeyId.validate((String)jwt.getHeader().getKeyId());
        PrivateKey privateKey = (PrivateKey)this.privateKeyProvider.getKey(validatedKeyId);
        return "Bearer " + this.jwtSerializer.serialize(jwt, privateKey);
    }
}

