/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.ui;

import com.atlassian.applinks.analytics.EntityLinksAdminViewEvent;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.ApplicationTypeVisitor;
import com.atlassian.applinks.api.application.bamboo.BambooApplicationType;
import com.atlassian.applinks.api.application.bitbucket.BitbucketApplicationType;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.applinks.api.application.crowd.CrowdApplicationType;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.applinks.api.application.generic.GenericApplicationType;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.applinks.api.application.refapp.RefAppApplicationType;
import com.atlassian.applinks.core.util.MessageFactory;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.internal.common.docs.DocumentationLinker;
import com.atlassian.applinks.ui.AbstractAppLinksAdminOnlyServlet;
import com.atlassian.applinks.ui.AbstractApplinksServlet;
import com.atlassian.applinks.ui.auth.AdminUIAuthenticator;
import com.atlassian.applinks.ui.velocity.ListEntityLinksContext;
import com.atlassian.applinks.ui.velocity.VelocityContextFactory;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class ListEntityLinksServlet
extends AbstractAppLinksAdminOnlyServlet {
    private static final String TEMPLATE_PATH = "com/atlassian/applinks/ui/admin/list_entity_links.vm";
    private final VelocityContextFactory velocityContextFactory;
    private final WebSudoManager webSudoManager;
    private final EventPublisher eventPublisher;

    public ListEntityLinksServlet(I18nResolver i18nResolver, MessageFactory messageFactory, TemplateRenderer templateRenderer, WebResourceManager webResourceManager, InternalHostApplication internalHostApplication, DocumentationLinker documentationLinker, LoginUriProvider loginUriProvider, AdminUIAuthenticator adminUIAuthenticator, VelocityContextFactory velocityContextFactory, WebSudoManager webSudoManager, XsrfTokenAccessor xsrfTokenAccessor, XsrfTokenValidator xsrfTokenValidator, EventPublisher eventPublisher) {
        super(i18nResolver, messageFactory, templateRenderer, webResourceManager, adminUIAuthenticator, documentationLinker, loginUriProvider, internalHostApplication, xsrfTokenAccessor, xsrfTokenValidator);
        this.velocityContextFactory = velocityContextFactory;
        this.webSudoManager = webSudoManager;
        this.eventPublisher = eventPublisher;
    }

    @Override
    protected List<String> getRequiredWebResources() {
        return Collections.singletonList("com.atlassian.applinks.applinks-plugin:list-entity-links");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            String[] pathParams = this.extractParams(request);
            String typeId = pathParams[pathParams.length - 2];
            String key = pathParams[pathParams.length - 1];
            this.publishAnalytics(typeId, key);
            ListEntityLinksContext context = this.velocityContextFactory.buildListEntityLinksContext(request, typeId, key);
            this.render(TEMPLATE_PATH, this.createRenderContext(key, context), request, response);
        }
        catch (WebSudoSessionException wse) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    private void publishAnalytics(String typeId, String key) {
        this.eventPublisher.publish((Object)new EntityLinksAdminViewEvent(typeId, key));
    }

    private Map<String, Object> createRenderContext(final String key, ListEntityLinksContext context) {
        final ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        mapBuilder.put((Object)"context", (Object)context);
        return ((ImmutableMap.Builder)this.internalHostApplication.getType().accept((ApplicationTypeVisitor)new ApplicationTypeVisitor<ImmutableMap.Builder<String, Object>>(){

            public ImmutableMap.Builder<String, Object> visit(@Nonnull BambooApplicationType type) {
                return mapBuilder.put((Object)"decorator", (Object)"atl.general");
            }

            public ImmutableMap.Builder<String, Object> visit(@Nonnull BitbucketApplicationType type) {
                return mapBuilder.put((Object)"projectKey", (Object)key).put((Object)"decorator", (Object)"bitbucket.project.settings").put((Object)"activeTab", (Object)"project-settings-entity-links");
            }

            public ImmutableMap.Builder<String, Object> visit(@Nonnull ConfluenceApplicationType type) {
                return mapBuilder.put((Object)"decorator", (Object)"atl.admin");
            }

            public ImmutableMap.Builder<String, Object> visit(@Nonnull CrowdApplicationType type) {
                return mapBuilder.put((Object)"decorator", (Object)"atl.admin");
            }

            public ImmutableMap.Builder<String, Object> visit(@Nonnull FishEyeCrucibleApplicationType type) {
                return mapBuilder.put((Object)"decorator", (Object)"atl.admin");
            }

            public ImmutableMap.Builder<String, Object> visit(@Nonnull GenericApplicationType type) {
                return mapBuilder.put((Object)"decorator", (Object)"atl.admin");
            }

            public ImmutableMap.Builder<String, Object> visit(@Nonnull JiraApplicationType type) {
                return mapBuilder.put((Object)"decorator", (Object)"atl.admin");
            }

            public ImmutableMap.Builder<String, Object> visit(@Nonnull RefAppApplicationType type) {
                return mapBuilder.put((Object)"decorator", (Object)"atl.admin");
            }

            public ImmutableMap.Builder<String, Object> visitDefault(@Nonnull ApplicationType applicationType) {
                return mapBuilder.put((Object)"decorator", (Object)"atl.admin");
            }
        })).build();
    }

    private String[] extractParams(HttpServletRequest request) {
        String[] pathParams = StringUtils.split((String)request.getPathInfo(), (char)'/');
        if (pathParams.length < 2) {
            throw new AbstractApplinksServlet.BadRequestException(this.messageFactory.newLocalizedMessage("Servlet URL should be of form /listEntityLinks/{entity-type}/{entity-key}"));
        }
        return pathParams;
    }
}

