/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.common.net;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletResponse;

public final class ResponseHeaderUtil {
    @VisibleForTesting
    static final String HEADER_XFRAME_OPTIONS = "X-Frame-Options";
    @VisibleForTesting
    static final String HEADER_CONTENT_SECURITY_POLICY = "Content-Security-Policy";

    private ResponseHeaderUtil() {
    }

    public static void preventCrossFrameClickJacking(@Nonnull HttpServletResponse response) {
        Preconditions.checkNotNull((Object)response, (Object)"response");
        response.setHeader(HEADER_XFRAME_OPTIONS, "SAMEORIGIN");
        response.setHeader(HEADER_CONTENT_SECURITY_POLICY, "frame-ancestors 'self'");
    }
}

