/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.status.remote;

import com.atlassian.applinks.internal.status.error.ApplinkErrorType;
import com.atlassian.applinks.internal.status.error.ApplinkErrors;
import com.atlassian.applinks.internal.status.error.ApplinkStatusException;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RemoteNetworkException
extends ApplinkStatusException {
    private final ApplinkErrorType applinkErrorType;
    private final Class<? extends Throwable> underlyingErrorType;

    public RemoteNetworkException(@Nonnull ApplinkErrorType applinkErrorType, @Nonnull Class<? extends Throwable> underlyingErrorType, @Nullable String message) {
        super(message);
        this.applinkErrorType = (ApplinkErrorType)((Object)Preconditions.checkNotNull((Object)((Object)applinkErrorType), (Object)"applinkErrorType"));
        this.underlyingErrorType = (Class)Preconditions.checkNotNull(underlyingErrorType, (Object)"underlyingErrorType");
    }

    public RemoteNetworkException(@Nonnull ApplinkErrorType applinkErrorType, @Nonnull Class<? extends Throwable> underlyingErrorType, @Nullable String message, @Nullable Throwable cause) {
        super(message, cause);
        this.applinkErrorType = (ApplinkErrorType)((Object)Preconditions.checkNotNull((Object)((Object)applinkErrorType), (Object)"applinkErrorType"));
        this.underlyingErrorType = (Class)Preconditions.checkNotNull(underlyingErrorType, (Object)"underlyingErrorType");
    }

    @Override
    @Nonnull
    public final ApplinkErrorType getType() {
        return this.applinkErrorType;
    }

    @Override
    @Nullable
    public final String getDetails() {
        Throwable underlyingError = ApplinkErrors.findCauseOfType(this, this.underlyingErrorType);
        if (underlyingError != null) {
            return this.toErrorDetails(underlyingError);
        }
        return null;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + ": " + this.internalToString();
    }

    @Nullable
    protected String toErrorDetails(Throwable underlyingError) {
        return ApplinkErrors.toDetails(underlyingError);
    }

    private String internalToString() {
        return Objects.toStringHelper((Object)this).add("errorType", (Object)this.applinkErrorType).add("details", (Object)this.getDetails()).toString();
    }
}

