/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.internal.rest.model.status;

import com.atlassian.applinks.internal.common.rest.model.applink.RestMinimalApplicationLink;
import com.atlassian.applinks.internal.rest.model.BaseRestEntity;
import com.atlassian.applinks.internal.rest.model.ReadOnlyRestRepresentation;
import com.atlassian.applinks.internal.rest.model.status.RestApplinkError;
import com.atlassian.applinks.internal.rest.model.status.RestApplinkOAuthStatus;
import com.atlassian.applinks.internal.status.ApplinkStatus;
import com.google.common.base.Preconditions;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class RestApplinkStatus
extends BaseRestEntity
implements ReadOnlyRestRepresentation<ApplinkStatus> {
    public static final String LINK = "link";
    public static final String WORKING = "working";
    public static final String ERROR = "error";
    public static final String LOCAL_AUTHENTICATION = "localAuthentication";
    public static final String REMOTE_AUTHENTICATION = "remoteAuthentication";

    public RestApplinkStatus(@Nonnull ApplinkStatus status) {
        this(status, null);
    }

    public RestApplinkStatus(@Nonnull ApplinkStatus status, @Nullable URI authorisationCallback) {
        Preconditions.checkNotNull((Object)status, (Object)"status");
        this.put(LINK, (Object)new RestMinimalApplicationLink(status.getLink()));
        this.put(WORKING, (Object)status.isWorking());
        this.put(LOCAL_AUTHENTICATION, (Object)new RestApplinkOAuthStatus(status.getLocalAuthentication()));
        this.putAs(REMOTE_AUTHENTICATION, status.getRemoteAuthentication(), RestApplinkOAuthStatus.class);
        if (!status.isWorking()) {
            this.put(ERROR, (Object)status.getError().accept(new RestApplinkError.Visitor(authorisationCallback)));
        }
    }
}

