/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.internal.status.ApplinkStatus;
import com.atlassian.applinks.internal.status.error.ApplinkError;
import com.atlassian.applinks.spi.application.IdentifiableType;
import javax.annotation.Nonnull;

@EventName(value="applinks.detailed.status")
public class ApplinksStatusEvent {
    protected static final String WORKING_STATUS = "working";
    private final String type;
    private final String applicationId;
    private final String status;
    private final String category;
    private final boolean basic;
    private final boolean trusted;
    private final boolean other;
    private final boolean cors;
    private final boolean oauthTwoLO;
    private final boolean oauthTwoLOi;
    private final boolean oauthThreeLO;

    private ApplinksStatusEvent(Builder builder) {
        this.applicationId = builder.applicationId;
        this.status = builder.status;
        this.category = builder.category;
        this.type = builder.type;
        this.basic = builder.basic;
        this.trusted = builder.trusted;
        this.cors = builder.cors;
        this.oauthTwoLO = builder.twoLo;
        this.oauthTwoLOi = builder.twoLoi;
        this.oauthThreeLO = builder.threeLo;
        this.other = builder.other;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getType() {
        return this.type;
    }

    public String getStatus() {
        return this.status;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean isBasic() {
        return this.basic;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public boolean isOther() {
        return this.other;
    }

    public boolean isCors() {
        return this.cors;
    }

    public boolean isOauthTwoLO() {
        return this.oauthTwoLO;
    }

    public boolean isOauthTwoLOi() {
        return this.oauthTwoLOi;
    }

    public boolean isOauthThreeLO() {
        return this.oauthThreeLO;
    }

    public static class Builder {
        private final String applicationId;
        private final String type;
        private final String status;
        private final String category;
        public boolean basic;
        public boolean trusted;
        public boolean cors;
        public boolean twoLo;
        public boolean twoLoi;
        public boolean threeLo;
        public boolean other;

        public Builder(@Nonnull ApplinkStatus applinkStatus) {
            this.applicationId = applinkStatus.getLink().getId().get();
            ApplicationType appType = applinkStatus.getLink().getType();
            this.type = appType instanceof IdentifiableType ? ((IdentifiableType)appType).getId().get() : appType.getI18nKey();
            ApplinkError error = applinkStatus.getError();
            if (error == null) {
                this.status = ApplinksStatusEvent.WORKING_STATUS;
                this.category = ApplinksStatusEvent.WORKING_STATUS;
            } else {
                this.status = error.getType().name().toLowerCase();
                this.category = error.getType().getCategory().name().toLowerCase();
            }
        }

        public ApplinksStatusEvent build() {
            return new ApplinksStatusEvent(this);
        }
    }
}

