(function($){
    /**
     * Init UI bindings.
     */
    function init() {
        AppLinks.Creation.userDefinedUrlField = $('#applinks-url-entered');
        AppLinks.Creation.createAppLinkButton = $('.v2-url-input input[type="submit"]');

        AppLinks.Creation.Dialogs.bindDialogBehaviors();

        $('.applinks-lab-info').click(function(e) {
            if (e.target.className === 'applinks-lab-message') {
                AppLinks.SPI.enableFeature('V3_UI', function() {
                    AJS.trigger('analyticsEvent', {name: 'applinks.switchto.v3'});
                    location.reload();
                });
            }
        });

        // bind events to the main application url textbox.
        if(AppLinks.Util.isPreIE9()) {
            // > ie8 supports 'input'
            AppLinks.Creation.userDefinedUrlField.on("propertychange", function() {
                AppLinks.Creation.Dialogs.setSubmitStatus();
            });
        } else {
            AppLinks.Creation.userDefinedUrlField.on('input', function() {
                AppLinks.Creation.Dialogs.setSubmitStatus();
            });
        }

        AppLinks.Creation.Dialogs.resetProcess();

        if (AppLinks.Creation.getCreationState().isCreatingReciprocal()) {

            var url = AppLinks.Creation.getSubmittedRemoteUrl();
            AppLinks.Creation.getCreationState().setCorrectedUrl(url);

            if (!AppLinks.Creation.userDefinedUrlField.length) {
                //something is wrong
                AJS.log('Something is wrong. New workflow resources provided but UI elements not found.');
                AppLinks.Creation.Dialogs.showApplinkCreationWorkflowNotAvailableDialog(AJS.I18n.getText('applinks.create.fail.process.unavailable.reciprocal', AppLinks.Creation.getCreationState().getCorrectedUrl()), AppLinks.Creation.globalCreationState);
                return;
            }
            // in App2 after a redirect from App1
            // start the creation process
            // ignore errors
            // optionally respect redirects
            AppLinks.Creation.Process.fetchManifests(false, AppLinks.Creation.getCreationState());
        } else {


            // App 1
            $('#createApplicationLink').submit(function(e) {
                //Not always called via an event.
                e && e.preventDefault();

                if(AppLinks.Creation.createAppLinkButton.prop('disabled')
                    && AppLinks.Creation.getCreationState().getInitiatorTargetUrl() == null) {
                    return;
                }

                AppLinks.UI.hideErrorBox();
                AppLinks.UI.hideInfoBox();

                if (!AppLinks.Creation.userDefinedUrlField.length) {
                    //something is wrong
                    AJS.log('Something is wrong. New workflow resources provided but UI elements not found.');
                    AppLinks.Creation.Dialogs.showApplinkCreationWorkflowNotAvailableDialog(null, AppLinks.Creation.getCreationState());
                    return;
                }

                // started a new creation process so explicitly create a new creationState
                AppLinks.Creation.initCreationState();

                // start the status log
                AppLinks.Creation.getCreationState().updateStatusLog(AppLinks.Creation.STATUS_CREATION_INPROGRESS);

                // must be run after as it tweaks the creationState to reflect the external initiation if there is one.
                AppLinks.ExternalInitiation.init(AppLinks.Creation.getCreationState());

                // make sure the entered URL has a protocol before going any further.
                var url = AppLinks.UI.addProtocolToURL(AppLinks.Creation.userDefinedUrlField.val());
                AppLinks.Creation.getCreationState().setUserDefinedUrl(url);
                AppLinks.Creation.getCreationState().setCorrectedUrl(AppLinks.Creation.getCreationState().getUserDefinedUrl());

                // will disable the form submission button and add a spinner.
                AppLinks.Creation.Dialogs.resetProcess();

                // start the creation process
                // don't ignore errors
                // respect redirects
                AppLinks.Creation.Process.fetchManifests(false, AppLinks.Creation.getCreationState());
            });

            if (AppLinks.Creation.getCreationState().reciprocalCreationCompleted()) {
                // 2-stage Local Creation: the following would support creation of the link and configure incoming authentication in the local app,
                // before redirecting to the remote app to create a link and configure incoming and outgoing authentication
                // before redirecting to the local app to configure the outgoing authentication.
                if(AppLinks.Creation.Process.twoStageCreation) {
                    var ualLinkCreation = AppLinks.Creation.Process.retrieveUalLinkAndConfigureOutgoing(AppLinks.Creation.getCreationState());
                    ualLinkCreation.progress(function () {
                        //
                    });
                    ualLinkCreation.done(function () {
                        AppLinks.Util.waitUntilDone(function() {
                            return AppLinks.Creation.Process.successNoRedirect(AppLinks.Creation.getCreationState());
                        })();
                    });
                    ualLinkCreation.fail(function () {
                        //@todo: handle promise rejection, likely an ajax call failure.
                    });
                } else {
                    AppLinks.Creation.Process.showFinalStatus(AppLinks.Creation.getCreationState());
                }
            }
        }
    }

    $(function() {
        AppLinks.SPI.setApiVersion("3.0");

        AppLinks.Creation.getAndDisplayOutstandingMessages();

        init();

        // must be run after init() as it needs everything it sets up.
        AppLinks.ExternalInitiation.init(AppLinks.Creation.globalCreationState);

        // if the the process was initiated externally and a starting url was provided, shortcut the first stage of the process
        if(AppLinks.Creation.globalCreationState.initiatorTargetUrl !== null) {
            $('#createApplicationLink').submit();
        }
    });
})(AJS.$);
