(function (_, Backbone, templateNamespace) {

    AJS.$.namespace('Agent.Applinks.Page');

    /**
     * Main page container view, contains permissions definition.
     */
    Agent.Applinks.Page = Backbone.View.extend({

        template: templateNamespace,

        // TODO need a way to map accessLevel names to index in this array
        // TODO rename as accessLevels?
        // TODO this should be loaded from the server
        levels: [
            {
                key: "ANONYMOUS",
                title: AJS.I18n.getText("applinks.agent.permission.anonymous.title"),
                description: AJS.I18n.getText("applinks.agent.permission.anonymous.description")
            },
            {
                key: "USERAUTH",
                title: AJS.I18n.getText("applinks.agent.permission.userauth.title"),
                description: AJS.I18n.getText("applinks.agent.permission.userauth.description")
            },
            {
                key: "SERVERAUTH",
                title: AJS.I18n.getText("applinks.agent.permission.serverauth.title"),
                description: AJS.I18n.getText("applinks.agent.permission.serverauth.description")
            },
            {
                key: "PREAUTH",
                title: AJS.I18n.getText("applinks.agent.permission.preauth.title"),
                description: AJS.I18n.getText("applinks.agent.permission.preauth.description")
            }
        ],

        initialize: function () {
            this.table = new Agent.Applinks.Table({
                el: this.$el.find('.content'),
                levels: this.levels
            });
        }

    });

})(_, Backbone, agent.applinks.templates.page);


