;(function($) {
    $(function() {
        // set up I18n for dynamical calls on client side, remember to use " for AJS.I18n.getText
        // Please make sure that AbstractApplinksServlet.java has put the appLinksI18n.entries correctly on the page
        AJS.I18n.keys = AJS.I18n.keys || {};
        $.extend(AJS.I18n.keys, appLinksI18n.entries);

        // This method is for backward compatibility, since in previous AUI,
        // we don't have a method to format the i18n text for the client side
        AJS.I18n.getTextOnClient = function(key) {
            var params = Array.prototype.slice.call(arguments, 1);
            if (AJS.I18n.keys && Object.prototype.hasOwnProperty.call(AJS.I18n.keys, key)) {
                return AJS.format.apply(null, [ AJS.I18n.keys[key] ].concat(params));
            }
            return key;
        }
    })
})(AJS.$);