/**
 * Utility functions for generating URLs in JS, including a link to applinks admin screen.
 */
(function(){
    AppLinks.Urls = {

        /**
         * Generate a URL from the base and parameters.
         * @param baseUrl the baseUrl
         * @param parametersMap a map of parameters to add, in the form of { parameterName :  parameterValue }
         * @return {String}
         */
        generateUrl: function(baseUrl, parametersMap) {
            var redirectUrl = baseUrl;

            if(typeof parametersMap == 'undefined') {
                return redirectUrl;
            } else {
                AJS.$.each(parametersMap, function(key, value) {
                    if(redirectUrl.indexOf('?') < 0) {
                        redirectUrl = redirectUrl + '?';
                    } else {
                        redirectUrl = redirectUrl + '&';
                    }
                    redirectUrl = redirectUrl + key + "=" + encodeURIComponent(JSON.stringify(value))
                });

                return redirectUrl;
            }
        }
    };

    AppLinks.Urls.Local = {

        admin: function(params) {
            var url = AJS.contextPath() + "/plugins/servlet/applinks/listApplicationLinks";
            return AppLinks.Urls.generateUrl(url, params);
        }
    };

    AppLinks.Urls.Remote = {

        /**
         * Generate a URL to remote Applinks Admin screen. For compatibility it needs to accept `applicationTypeId`.
         *
         * @param remoteBaseUrl
         * @param applicationTypeId
         * @param params extra URL params
         * @returns {String}
         */
        admin: function(remoteBaseUrl, applicationTypeId, params) {
            var suffix = applicationTypeId === 'confluence' ?
                "/admin/listapplicationlinks.action" :
                "/plugins/servlet/applinks/listApplicationLinks";
            var url = remoteBaseUrl + suffix;

            return AppLinks.Urls.generateUrl(url, params);
        }
    };
})();
